/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.relational;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.udf.builtin.relational.tvf.CapacityTableFunction;
import org.apache.iotdb.commons.udf.builtin.relational.tvf.HOPTableFunction;
import org.apache.iotdb.commons.udf.builtin.relational.tvf.SessionTableFunction;
import org.apache.iotdb.commons.udf.builtin.relational.tvf.VariationTableFunction;
import org.apache.iotdb.udf.api.relational.TableFunction;

public enum TableBuiltinTableFunction {
    HOP("hop"),
    SESSION("session"),
    VARIATION("variation"),
    CAPACITY("capacity");

    private final String functionName;
    private static final Set<String> BUILT_IN_TABLE_FUNCTION_NAME;

    private TableBuiltinTableFunction(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public static Set<String> getBuiltInTableFunctionName() {
        return BUILT_IN_TABLE_FUNCTION_NAME;
    }

    public static boolean isBuiltInTableFunction(String functionName) {
        return BUILT_IN_TABLE_FUNCTION_NAME.contains(functionName.toLowerCase());
    }

    public static TableFunction getBuiltinTableFunction(String functionName) {
        switch (functionName.toLowerCase()) {
            case "hop": {
                return new HOPTableFunction();
            }
            case "session": {
                return new SessionTableFunction();
            }
            case "variation": {
                return new VariationTableFunction();
            }
            case "capacity": {
                return new CapacityTableFunction();
            }
        }
        throw new UnsupportedOperationException("Unsupported table function: " + functionName);
    }

    static {
        BUILT_IN_TABLE_FUNCTION_NAME = new HashSet<String>(Arrays.stream(TableBuiltinTableFunction.values()).map(TableBuiltinTableFunction::getFunctionName).collect(Collectors.toList()));
    }
}

