/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.WritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class WritableMemChunkGroup
implements IWritableMemChunkGroup {
    private Map<String, IWritableMemChunk> memChunkMap = new HashMap<String, IWritableMemChunk>();

    @Override
    public void writeTablet(long[] times, Object[] columns, BitMap[] bitMaps, List<IMeasurementSchema> schemaList, int start, int end, TSStatus[] results) {
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null) continue;
            IWritableMemChunk memChunk = this.createMemChunkIfNotExistAndGet(schemaList.get(i));
            memChunk.writeNonAlignedTablet(times, columns[i], bitMaps == null ? null : bitMaps[i], schemaList.get(i).getType(), start, end);
        }
    }

    private IWritableMemChunk createMemChunkIfNotExistAndGet(IMeasurementSchema schema) {
        return this.memChunkMap.computeIfAbsent(schema.getMeasurementName(), k -> new WritableMemChunk(schema));
    }

    @Override
    public void release() {
        for (IWritableMemChunk memChunk : this.memChunkMap.values()) {
            memChunk.release();
        }
    }

    @Override
    public long count() {
        long count = 0L;
        for (IWritableMemChunk memChunk : this.memChunkMap.values()) {
            count += memChunk.count();
        }
        return count;
    }

    @Override
    public boolean contains(String measurement) {
        return this.memChunkMap.containsKey(measurement);
    }

    @Override
    public void writeRow(long insertTime, Object[] objectValue, List<IMeasurementSchema> schemaList) {
        for (int i = 0; i < objectValue.length; ++i) {
            if (objectValue[i] == null) continue;
            IWritableMemChunk memChunk = this.createMemChunkIfNotExistAndGet(schemaList.get(i));
            memChunk.writeNonAlignedPoint(insertTime, objectValue[i]);
        }
    }

    @Override
    public Map<String, IWritableMemChunk> getMemChunkMap() {
        return this.memChunkMap;
    }

    @Override
    public boolean isEmpty() {
        return this.memChunkMap.isEmpty() || this.count() == 0L;
    }

    @Override
    public long delete(ModEntry modEntry) {
        Iterator<Map.Entry<String, IWritableMemChunk>> iter = this.memChunkMap.entrySet().iterator();
        long deletedPointsNumber = 0L;
        while (iter.hasNext()) {
            Map.Entry<String, IWritableMemChunk> entry = iter.next();
            if (!modEntry.affects(entry.getKey())) continue;
            IWritableMemChunk chunk = entry.getValue();
            if (modEntry.getStartTime() == Long.MIN_VALUE && modEntry.getEndTime() == Long.MAX_VALUE) {
                iter.remove();
                deletedPointsNumber += chunk.count();
                chunk.release();
                continue;
            }
            deletedPointsNumber += (long)chunk.delete(modEntry.getStartTime(), modEntry.getEndTime());
            if (chunk.count() != 0L) continue;
            iter.remove();
        }
        return deletedPointsNumber;
    }

    @Override
    public long deleteTime(ModEntry modEntry) {
        return this.delete(modEntry);
    }

    @Override
    public IWritableMemChunk getWritableMemChunk(String measurement) {
        if (!this.memChunkMap.containsKey(measurement)) {
            return null;
        }
        return this.memChunkMap.get(measurement);
    }

    @Override
    public long getMaxTime() {
        long maxTime = Long.MIN_VALUE;
        for (IWritableMemChunk memChunk : this.memChunkMap.values()) {
            maxTime = Math.max(maxTime, memChunk.getMaxTime());
        }
        return maxTime;
    }

    @Override
    public int serializedSize() {
        int size = 0;
        size += 4;
        for (Map.Entry<String, IWritableMemChunk> entry : this.memChunkMap.entrySet()) {
            size += ReadWriteIOUtils.sizeToWrite((String)entry.getKey());
            size += entry.getValue().serializedSize();
        }
        return size;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        buffer.putInt(this.memChunkMap.size());
        for (Map.Entry<String, IWritableMemChunk> entry : this.memChunkMap.entrySet()) {
            WALWriteUtils.write(entry.getKey(), buffer);
            IWritableMemChunk memChunk = entry.getValue();
            memChunk.serializeToWAL(buffer);
        }
    }

    public static WritableMemChunkGroup deserialize(DataInputStream stream) throws IOException {
        WritableMemChunkGroup memChunkGroup = new WritableMemChunkGroup();
        int memChunkMapSize = stream.readInt();
        for (int i = 0; i < memChunkMapSize; ++i) {
            String measurement = ReadWriteIOUtils.readString((InputStream)stream);
            WritableMemChunk memChunk = WritableMemChunk.deserialize(stream);
            memChunkGroup.memChunkMap.put(measurement, memChunk);
        }
        return memChunkGroup;
    }

    public static WritableMemChunkGroup deserializeSingleTVListMemChunks(DataInputStream stream) throws IOException {
        WritableMemChunkGroup memChunkGroup = new WritableMemChunkGroup();
        int memChunkMapSize = stream.readInt();
        for (int i = 0; i < memChunkMapSize; ++i) {
            String measurement = ReadWriteIOUtils.readString((InputStream)stream);
            WritableMemChunk memChunk = WritableMemChunk.deserializeSingleTVListMemChunks(stream);
            memChunkGroup.memChunkMap.put(measurement, memChunk);
        }
        return memChunkGroup;
    }
}

