/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class QualifiedName {
    private final List<Identifier> originalParts;
    private final List<String> parts;
    private final String name;
    @Nullable
    private final QualifiedName prefix;
    private final String suffix;

    public static QualifiedName of(String first, String ... rest) {
        Objects.requireNonNull(first, "first is null");
        return QualifiedName.of((Iterable)Lists.asList((Object)first, (Object[])rest).stream().map(Identifier::new).collect(ImmutableList.toImmutableList()));
    }

    public static QualifiedName of(String name) {
        Objects.requireNonNull(name, "name is null");
        return QualifiedName.of((Iterable<Identifier>)ImmutableList.of((Object)new Identifier(name)));
    }

    public static QualifiedName of(Iterable<Identifier> originalParts) {
        Objects.requireNonNull(originalParts, "originalParts is null");
        Preconditions.checkArgument((!Iterables.isEmpty(originalParts) ? 1 : 0) != 0, (Object)"originalParts is empty");
        return new QualifiedName((List<Identifier>)ImmutableList.copyOf(originalParts));
    }

    public QualifiedName(List<Identifier> originalParts, List<String> parts, String name, @Nullable QualifiedName prefix, String suffix) {
        this.originalParts = ImmutableList.copyOf(originalParts);
        this.parts = ImmutableList.copyOf(parts);
        this.name = Objects.requireNonNull(name, "name is null");
        this.prefix = prefix;
        this.suffix = suffix;
    }

    private QualifiedName(List<Identifier> originalParts) {
        this.originalParts = originalParts;
        ImmutableList.Builder partsBuilder = ImmutableList.builderWithExpectedSize((int)originalParts.size());
        for (Identifier identifier : originalParts) {
            partsBuilder.add((Object)QualifiedName.mapIdentifier(identifier));
        }
        this.parts = partsBuilder.build();
        this.name = String.join((CharSequence)".", this.parts);
        if (originalParts.size() == 1) {
            this.prefix = null;
            this.suffix = QualifiedName.mapIdentifier(originalParts.get(0));
        } else {
            List<Identifier> subList = originalParts.subList(0, originalParts.size() - 1);
            this.prefix = new QualifiedName(subList);
            this.suffix = QualifiedName.mapIdentifier(originalParts.get(originalParts.size() - 1));
        }
    }

    public static String mapIdentifier(Identifier identifier) {
        return identifier.getValue().toLowerCase(Locale.ENGLISH);
    }

    public List<String> getParts() {
        return this.parts;
    }

    public List<Identifier> getOriginalParts() {
        return this.originalParts;
    }

    public Optional<QualifiedName> getPrefix() {
        return Optional.ofNullable(this.prefix);
    }

    public boolean hasSuffix(QualifiedName suffix) {
        if (this.parts.size() < suffix.getParts().size()) {
            return false;
        }
        int start = this.parts.size() - suffix.getParts().size();
        return this.parts.subList(start, this.parts.size()).equals(suffix.getParts());
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.parts.equals(((QualifiedName)o).parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.originalParts.size(), (OutputStream)stream);
        for (Identifier identifier : this.originalParts) {
            Expression.serialize((Expression)identifier, stream);
        }
        ReadWriteIOUtils.write((int)this.parts.size(), (OutputStream)stream);
        for (String part : this.parts) {
            ReadWriteIOUtils.write((String)part, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((String)this.name, (OutputStream)stream);
        if (this.prefix != null) {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.prefix.serialize(stream);
        } else {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((String)this.suffix, (OutputStream)stream);
    }

    public static QualifiedName deserialize(ByteBuffer byteBuffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Identifier> originalParts = new ArrayList<Identifier>(size);
        while (size-- > 0) {
            originalParts.add((Identifier)Expression.deserialize(byteBuffer));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<String> parts = new ArrayList<String>(size);
        while (size-- > 0) {
            parts.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        String name = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        byte hasPrefixByte = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        QualifiedName prefix = null;
        if (hasPrefixByte == 1) {
            prefix = QualifiedName.deserialize(byteBuffer);
        }
        String suffix = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        return new QualifiedName(originalParts, parts, name, prefix, suffix);
    }
}

