/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.function.BoundSignature;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ResolvedFunction;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationTreeDeviceViewScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.DeviceTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TreeDeviceViewScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.TimestampType;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class AggregationTableScanNode
extends DeviceTableScanNode {
    protected Assignments projection;
    protected Map<Symbol, AggregationNode.Aggregation> aggregations;
    protected AggregationNode.GroupingSetDescriptor groupingSets;
    protected List<Symbol> preGroupedSymbols;
    protected AggregationNode.Step step;
    protected Optional<Symbol> groupIdSymbol;

    public AggregationTableScanNode(PlanNodeId id, QualifiedObjectName qualifiedObjectName, List<Symbol> outputSymbols, Map<Symbol, ColumnSchema> assignments, List<DeviceEntry> deviceEntries, Map<Symbol, Integer> idAndAttributeIndexMap, Ordering scanOrder, Expression timePredicate, Expression pushDownPredicate, long pushDownLimit, long pushDownOffset, boolean pushLimitToEachDevice, boolean containsNonAlignedDevice, Assignments projection, Map<Symbol, AggregationNode.Aggregation> aggregations, AggregationNode.GroupingSetDescriptor groupingSets, List<Symbol> preGroupedSymbols, AggregationNode.Step step, Optional<Symbol> groupIdSymbol) {
        super(id, qualifiedObjectName, outputSymbols, assignments, deviceEntries, idAndAttributeIndexMap, scanOrder, timePredicate, pushDownPredicate, pushDownLimit, pushDownOffset, pushLimitToEachDevice, containsNonAlignedDevice);
        this.projection = projection;
        this.aggregations = AggregationTableScanNode.transformCountStar(aggregations, assignments);
        aggregations.values().forEach(aggregation -> aggregation.verifyArguments(step));
        Objects.requireNonNull(groupingSets, "groupingSets is null");
        groupIdSymbol.ifPresent(symbol -> Preconditions.checkArgument((boolean)groupingSets.getGroupingKeys().contains(symbol), (Object)"Grouping columns does not contain groupId column"));
        this.groupingSets = groupingSets;
        this.groupIdSymbol = Objects.requireNonNull(groupIdSymbol);
        boolean noOrderBy = aggregations.values().stream().map(AggregationNode.Aggregation::getOrderingScheme).noneMatch(Optional::isPresent);
        Preconditions.checkArgument((noOrderBy || step == AggregationNode.Step.SINGLE ? 1 : 0) != 0, (Object)"ORDER BY does not support distributed aggregation");
        this.step = step;
        List<Symbol> groupingKeys = groupingSets.getGroupingKeys();
        for (int i = 0; i < groupingKeys.size(); ++i) {
            if (!groupingKeys.get(i).getName().startsWith(SymbolAllocator.DATE_BIN_PREFIX)) continue;
            Preconditions.checkArgument((i == groupingKeys.size() - 1 ? 1 : 0) != 0, (Object)"date_bin function must be the last GroupingKey");
        }
        Objects.requireNonNull(preGroupedSymbols, "preGroupedSymbols is null");
        Preconditions.checkArgument((preGroupedSymbols.isEmpty() || groupingKeys.containsAll(preGroupedSymbols) ? 1 : 0) != 0, (Object)"Pre-grouped symbols must be a subset of the grouping keys");
        this.preGroupedSymbols = ImmutableList.copyOf(preGroupedSymbols);
        this.setOutputSymbols(AggregationTableScanNode.constructOutputSymbols(groupingSets, aggregations));
    }

    protected AggregationTableScanNode() {
    }

    private static List<Symbol> constructOutputSymbols(AggregationNode.GroupingSetDescriptor groupingSets, Map<Symbol, AggregationNode.Aggregation> aggregations) {
        ImmutableList.Builder outputs = ImmutableList.builder();
        outputs.addAll(groupingSets.getGroupingKeys());
        outputs.addAll(aggregations.keySet());
        return outputs.build();
    }

    private static Map<Symbol, AggregationNode.Aggregation> transformCountStar(Map<Symbol, AggregationNode.Aggregation> aggregations, Map<Symbol, ColumnSchema> assignments) {
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : aggregations.entrySet()) {
            Symbol symbol = entry.getKey();
            AggregationNode.Aggregation aggregation = entry.getValue();
            if (aggregation.getArguments().isEmpty()) {
                AggregationNode.Aggregation countStarAggregation = AggregationTableScanNode.getCountStarAggregation(aggregation);
                if (!AggregationTableScanNode.getTimeColumn(assignments).isPresent()) {
                    assignments.put(Symbol.of("time"), new ColumnSchema("time", (Type)TimestampType.TIMESTAMP, false, TsTableColumnCategory.TIME));
                }
                resultBuilder.put((Object)symbol, (Object)countStarAggregation);
                continue;
            }
            resultBuilder.put((Object)symbol, (Object)aggregation);
        }
        return resultBuilder.build();
    }

    private static AggregationNode.Aggregation getCountStarAggregation(AggregationNode.Aggregation aggregation) {
        ResolvedFunction resolvedFunction = aggregation.getResolvedFunction();
        ResolvedFunction countStarFunction = new ResolvedFunction(new BoundSignature("count", (Type)LongType.INT64, Collections.singletonList(TimestampType.TIMESTAMP)), resolvedFunction.getFunctionId(), resolvedFunction.getFunctionKind(), resolvedFunction.isDeterministic(), resolvedFunction.getFunctionNullability());
        return new AggregationNode.Aggregation(countStarFunction, Collections.singletonList(new SymbolReference("time")), aggregation.isDistinct(), aggregation.getFilter(), aggregation.getOrderingScheme(), aggregation.getMask());
    }

    public Assignments getProjection() {
        return this.projection;
    }

    public List<Symbol> getGroupingKeys() {
        return this.groupingSets.getGroupingKeys();
    }

    public AggregationNode.GroupingSetDescriptor getGroupingSets() {
        return this.groupingSets;
    }

    public Map<Symbol, AggregationNode.Aggregation> getAggregations() {
        return this.aggregations;
    }

    public List<Symbol> getPreGroupedSymbols() {
        return this.preGroupedSymbols;
    }

    public boolean isStreamable() {
        return true;
    }

    public AggregationNode.Step getStep() {
        return this.step;
    }

    public void setStep(AggregationNode.Step step) {
        this.step = step;
    }

    public int getGroupingSetCount() {
        return this.groupingSets.getGroupingSetCount();
    }

    public Set<Integer> getGlobalGroupingSets() {
        return this.groupingSets.getGlobalGroupingSets();
    }

    public Optional<Symbol> getGroupIdSymbol() {
        return this.groupIdSymbol;
    }

    @Override
    public AggregationTableScanNode clone() {
        return new AggregationTableScanNode(this.id, this.qualifiedObjectName, this.outputSymbols, this.assignments, this.deviceEntries, this.idAndAttributeIndexMap, this.scanOrder, this.timePredicate, this.pushDownPredicate, this.pushDownLimit, this.pushDownOffset, this.pushLimitToEachDevice, this.containsNonAlignedDevice, this.projection, this.aggregations, this.groupingSets, this.preGroupedSymbols, this.step, this.groupIdSymbol);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAggregationTableScan(this, context);
    }

    public static AggregationTableScanNode combineAggregationAndTableScan(PlanNodeId id, AggregationNode aggregationNode, ProjectNode projectNode, DeviceTableScanNode tableScanNode) {
        if (tableScanNode instanceof TreeDeviceViewScanNode) {
            TreeDeviceViewScanNode treeDeviceViewScanNode = (TreeDeviceViewScanNode)tableScanNode;
            return new AggregationTreeDeviceViewScanNode(id, tableScanNode.getQualifiedObjectName(), tableScanNode.getOutputSymbols(), tableScanNode.getAssignments(), tableScanNode.getDeviceEntries(), tableScanNode.getIdAndAttributeIndexMap(), tableScanNode.getScanOrder(), tableScanNode.getTimePredicate().orElse(null), tableScanNode.getPushDownPredicate(), tableScanNode.getPushDownLimit(), tableScanNode.getPushDownOffset(), tableScanNode.isPushLimitToEachDevice(), tableScanNode.containsNonAlignedDevice(), projectNode == null ? null : projectNode.getAssignments(), aggregationNode.getAggregations(), aggregationNode.getGroupingSets(), aggregationNode.getPreGroupedSymbols(), aggregationNode.getStep(), aggregationNode.getGroupIdSymbol(), treeDeviceViewScanNode.getTreeDBName(), treeDeviceViewScanNode.getMeasurementColumnNameMap());
        }
        return new AggregationTableScanNode(id, tableScanNode.getQualifiedObjectName(), tableScanNode.getOutputSymbols(), tableScanNode.getAssignments(), tableScanNode.getDeviceEntries(), tableScanNode.getIdAndAttributeIndexMap(), tableScanNode.getScanOrder(), tableScanNode.getTimePredicate().orElse(null), tableScanNode.getPushDownPredicate(), tableScanNode.getPushDownLimit(), tableScanNode.getPushDownOffset(), tableScanNode.isPushLimitToEachDevice(), tableScanNode.containsNonAlignedDevice(), projectNode == null ? null : projectNode.getAssignments(), aggregationNode.getAggregations(), aggregationNode.getGroupingSets(), aggregationNode.getPreGroupedSymbols(), aggregationNode.getStep(), aggregationNode.getGroupIdSymbol());
    }

    public static AggregationTableScanNode combineAggregationAndTableScan(PlanNodeId id, AggregationNode aggregationNode, ProjectNode projectNode, DeviceTableScanNode tableScanNode, AggregationNode.Step step) {
        if (tableScanNode instanceof TreeDeviceViewScanNode) {
            TreeDeviceViewScanNode treeDeviceViewScanNode = (TreeDeviceViewScanNode)tableScanNode;
            return new AggregationTreeDeviceViewScanNode(id, tableScanNode.getQualifiedObjectName(), tableScanNode.getOutputSymbols(), tableScanNode.getAssignments(), tableScanNode.getDeviceEntries(), tableScanNode.getIdAndAttributeIndexMap(), tableScanNode.getScanOrder(), tableScanNode.getTimePredicate().orElse(null), tableScanNode.getPushDownPredicate(), tableScanNode.getPushDownLimit(), tableScanNode.getPushDownOffset(), tableScanNode.isPushLimitToEachDevice(), tableScanNode.containsNonAlignedDevice(), projectNode == null ? null : projectNode.getAssignments(), aggregationNode.getAggregations(), aggregationNode.getGroupingSets(), aggregationNode.getPreGroupedSymbols(), step, aggregationNode.getGroupIdSymbol(), treeDeviceViewScanNode.getTreeDBName(), treeDeviceViewScanNode.getMeasurementColumnNameMap());
        }
        return new AggregationTableScanNode(id, tableScanNode.getQualifiedObjectName(), tableScanNode.getOutputSymbols(), tableScanNode.getAssignments(), tableScanNode.getDeviceEntries(), tableScanNode.getIdAndAttributeIndexMap(), tableScanNode.getScanOrder(), tableScanNode.getTimePredicate().orElse(null), tableScanNode.getPushDownPredicate(), tableScanNode.getPushDownLimit(), tableScanNode.getPushDownOffset(), tableScanNode.isPushLimitToEachDevice(), tableScanNode.containsNonAlignedDevice(), projectNode == null ? null : projectNode.getAssignments(), aggregationNode.getAggregations(), aggregationNode.getGroupingSets(), aggregationNode.getPreGroupedSymbols(), step, aggregationNode.getGroupIdSymbol());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AggregationTableScanNode that = (AggregationTableScanNode)o;
        return Objects.equals(this.qualifiedObjectName, that.qualifiedObjectName) && Objects.equals(this.outputSymbols, that.outputSymbols) && Objects.equals(this.regionReplicaSet, that.regionReplicaSet) && Objects.equals(this.projection, that.projection) && Objects.equals(this.aggregations, that.aggregations) && Objects.equals(this.groupingSets, that.groupingSets) && Objects.equals((Object)this.step, (Object)that.step) && Objects.equals(this.groupIdSymbol, that.groupIdSymbol);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.projection, this.aggregations, this.groupingSets, this.step, this.groupIdSymbol});
    }

    @Override
    public String toString() {
        return "AggregationTableScanNode-" + this.getPlanNodeId();
    }

    protected static void serializeMemberVariables(AggregationTableScanNode node, ByteBuffer byteBuffer) {
        DeviceTableScanNode.serializeMemberVariables((DeviceTableScanNode)node, byteBuffer, false);
        if (node.projection != null) {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((int)node.projection.getMap().size(), (ByteBuffer)byteBuffer);
            for (Map.Entry<Symbol, Object> entry : node.projection.getMap().entrySet()) {
                Symbol.serialize(entry.getKey(), byteBuffer);
                Expression.serialize((Expression)entry.getValue(), byteBuffer);
            }
        } else {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)node.aggregations.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<Symbol, Object> entry : node.aggregations.entrySet()) {
            Symbol.serialize(entry.getKey(), byteBuffer);
            ((AggregationNode.Aggregation)entry.getValue()).serialize(byteBuffer);
        }
        node.groupingSets.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)node.preGroupedSymbols.size(), (ByteBuffer)byteBuffer);
        for (Symbol symbol : node.preGroupedSymbols) {
            Symbol.serialize(symbol, byteBuffer);
        }
        node.step.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)node.groupIdSymbol.isPresent(), (ByteBuffer)byteBuffer);
        if (node.groupIdSymbol.isPresent()) {
            Symbol.serialize(node.groupIdSymbol.get(), byteBuffer);
        }
    }

    protected static void serializeMemberVariables(AggregationTableScanNode node, DataOutputStream stream) throws IOException {
        DeviceTableScanNode.serializeMemberVariables((DeviceTableScanNode)node, stream, false);
        if (node.projection != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            ReadWriteIOUtils.write((int)node.projection.getMap().size(), (OutputStream)stream);
            for (Map.Entry<Symbol, Object> entry : node.projection.getMap().entrySet()) {
                Symbol.serialize(entry.getKey(), stream);
                Expression.serialize((Expression)entry.getValue(), stream);
            }
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)node.aggregations.size(), (OutputStream)stream);
        for (Map.Entry<Symbol, Object> entry : node.aggregations.entrySet()) {
            Symbol.serialize(entry.getKey(), stream);
            ((AggregationNode.Aggregation)entry.getValue()).serialize(stream);
        }
        node.groupingSets.serialize(stream);
        ReadWriteIOUtils.write((int)node.preGroupedSymbols.size(), (OutputStream)stream);
        for (Symbol symbol : node.preGroupedSymbols) {
            Symbol.serialize(symbol, stream);
        }
        node.step.serialize(stream);
        ReadWriteIOUtils.write((Boolean)node.groupIdSymbol.isPresent(), (OutputStream)stream);
        if (node.groupIdSymbol.isPresent()) {
            Symbol.serialize(node.groupIdSymbol.get(), stream);
        }
    }

    protected static void deserializeMemberVariables(ByteBuffer byteBuffer, AggregationTableScanNode node) {
        int size;
        DeviceTableScanNode.deserializeMemberVariables(byteBuffer, node, false);
        Assignments.Builder projection = Assignments.builder();
        boolean hasProjection = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        if (hasProjection) {
            size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            while (size-- > 0) {
                projection.put(Symbol.deserialize(byteBuffer), Expression.deserialize(byteBuffer));
            }
        }
        node.projection = projection.build();
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        LinkedHashMap<Symbol, AggregationNode.Aggregation> aggregations = new LinkedHashMap<Symbol, AggregationNode.Aggregation>(size);
        while (size-- > 0) {
            aggregations.put(Symbol.deserialize(byteBuffer), AggregationNode.Aggregation.deserialize(byteBuffer));
        }
        node.aggregations = AggregationTableScanNode.transformCountStar(aggregations, node.getAssignments());
        node.groupingSets = AggregationNode.GroupingSetDescriptor.deserialize(byteBuffer);
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Symbol> preGroupedSymbols = new ArrayList<Symbol>(size);
        while (size-- > 0) {
            preGroupedSymbols.add(Symbol.deserialize(byteBuffer));
        }
        node.preGroupedSymbols = preGroupedSymbols;
        node.step = AggregationNode.Step.deserialize(byteBuffer);
        Optional<Object> groupIdSymbol = Optional.empty();
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            groupIdSymbol = Optional.of(Symbol.deserialize(byteBuffer));
        }
        node.groupIdSymbol = groupIdSymbol;
        node.outputSymbols = AggregationTableScanNode.constructOutputSymbols(node.getGroupingSets(), node.getAggregations());
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_AGGREGATION_TABLE_SCAN_NODE.serialize(byteBuffer);
        AggregationTableScanNode.serializeMemberVariables(this, byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_AGGREGATION_TABLE_SCAN_NODE.serialize(stream);
        AggregationTableScanNode.serializeMemberVariables(this, stream);
    }

    public static AggregationTableScanNode deserialize(ByteBuffer byteBuffer) {
        AggregationTableScanNode node = new AggregationTableScanNode();
        AggregationTableScanNode.deserializeMemberVariables(byteBuffer, node);
        node.setPlanNodeId(PlanNodeId.deserialize(byteBuffer));
        return node;
    }
}

