/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.table.InformationSchema;
import org.apache.iotdb.commons.schema.table.TableNodeStatus;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.TsTableInternalRPCUtil;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseInfo;
import org.apache.iotdb.confignode.rpc.thrift.TDescTable4InformationSchemaResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetDatabaseReq;
import org.apache.iotdb.confignode.rpc.thrift.TRegionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TTableColumnInfo;
import org.apache.iotdb.confignode.rpc.thrift.TTableInfo;
import org.apache.iotdb.db.pipe.metric.overview.PipeDataNodeRemainingEventAndTimeMetrics;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowPipePluginsTask;
import org.apache.iotdb.db.schemaengine.table.InformationSchemaUtils;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.Pair;

public class InformationSchemaContentSupplierFactory {
    private InformationSchemaContentSupplierFactory() {
    }

    public static Iterator<TsBlock> getSupplier(String tableName, List<TSDataType> dataTypes) {
        switch (tableName) {
            case "queries": {
                return new QueriesSupplier(dataTypes);
            }
            case "databases": {
                return new DatabaseSupplier(dataTypes);
            }
            case "tables": {
                return new TableSupplier(dataTypes);
            }
            case "columns": {
                return new ColumnSupplier(dataTypes);
            }
            case "regions": {
                return new RegionSupplier(dataTypes);
            }
            case "pipes": {
                return new PipeSupplier(dataTypes);
            }
            case "pipe_plugins": {
                return new PipePluginSupplier(dataTypes);
            }
            case "topics": {
                return new TopicSupplier(dataTypes);
            }
            case "subscriptions": {
                return new SubscriptionSupplier(dataTypes);
            }
        }
        throw new UnsupportedOperationException("Unknown table: " + tableName);
    }

    private static class QueriesSupplier
    extends TsBlockSupplier {
        private final long currTime = System.currentTimeMillis();
        protected int nextConsumedIndex;
        private final List<IQueryExecution> queryExecutions = Coordinator.getInstance().getAllQueryExecutions();

        private QueriesSupplier(List<TSDataType> dataTypes) {
            super(dataTypes);
        }

        @Override
        protected void constructLine() {
            IQueryExecution queryExecution = this.queryExecutions.get(this.nextConsumedIndex);
            if (queryExecution.getSQLDialect().equals((Object)IClientSession.SqlDialect.TABLE)) {
                String[] splits = queryExecution.getQueryId().split("_");
                int dataNodeId = Integer.parseInt(splits[splits.length - 1]);
                this.columnBuilders[0].writeBinary(BytesUtils.valueOf((String)queryExecution.getQueryId()));
                this.columnBuilders[1].writeLong(TimestampPrecisionUtils.convertToCurrPrecision(queryExecution.getStartExecutionTime(), TimeUnit.MILLISECONDS));
                this.columnBuilders[2].writeInt(dataNodeId);
                this.columnBuilders[3].writeFloat((float)(this.currTime - queryExecution.getStartExecutionTime()) / 1000.0f);
                this.columnBuilders[4].writeBinary(BytesUtils.valueOf((String)queryExecution.getExecuteSQL().orElse("UNKNOWN")));
                this.columnBuilders[5].writeBinary(BytesUtils.valueOf((String)queryExecution.getUser()));
                this.resultBuilder.declarePosition();
            }
            ++this.nextConsumedIndex;
        }

        @Override
        public boolean hasNext() {
            return this.nextConsumedIndex < this.queryExecutions.size();
        }
    }

    private static class DatabaseSupplier
    extends TsBlockSupplier {
        private Iterator<Map.Entry<String, TDatabaseInfo>> iterator;
        private TDatabaseInfo currentDatabase;
        private boolean hasShownInformationSchema;

        private DatabaseSupplier(List<TSDataType> dataTypes) {
            super(dataTypes);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.iterator = client.showDatabase(new TGetDatabaseReq(Arrays.asList(SchemaConstant.ALL_RESULT_NODES), SchemaConstant.ALL_MATCH_SCOPE.serialize()).setIsTableModel(true)).getDatabaseInfoMap().entrySet().iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            if (!this.hasShownInformationSchema) {
                InformationSchemaUtils.buildDatabaseTsBlock(s -> true, this.resultBuilder, true, false);
                this.hasShownInformationSchema = true;
                return;
            }
            this.columnBuilders[0].writeBinary(new Binary(this.currentDatabase.getName(), TSFileConfig.STRING_CHARSET));
            if (Long.MAX_VALUE == this.currentDatabase.getTTL()) {
                this.columnBuilders[1].writeBinary(new Binary("INF", TSFileConfig.STRING_CHARSET));
            } else {
                this.columnBuilders[1].writeBinary(new Binary(String.valueOf(this.currentDatabase.getTTL()), TSFileConfig.STRING_CHARSET));
            }
            this.columnBuilders[2].writeInt(this.currentDatabase.getSchemaReplicationFactor());
            this.columnBuilders[3].writeInt(this.currentDatabase.getDataReplicationFactor());
            this.columnBuilders[4].writeLong(this.currentDatabase.getTimePartitionInterval());
            this.columnBuilders[5].writeInt(this.currentDatabase.getSchemaRegionNum());
            this.columnBuilders[6].writeInt(this.currentDatabase.getDataRegionNum());
            this.resultBuilder.declarePosition();
            this.currentDatabase = null;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasShownInformationSchema) {
                return true;
            }
            if (this.iterator.hasNext()) {
                this.currentDatabase = this.iterator.next().getValue();
            }
            return Objects.nonNull(this.currentDatabase);
        }
    }

    private static class TableSupplier
    extends TsBlockSupplier {
        private Iterator<Map.Entry<String, List<TTableInfo>>> dbIterator;
        private Iterator<TTableInfo> tableInfoIterator = null;
        private TTableInfo currentTable;
        private String dbName;

        private TableSupplier(List<TSDataType> dataTypes) {
            super(dataTypes);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                Map databaseTableInfoMap = client.showTables4InformationSchema().getDatabaseTableInfoMap();
                databaseTableInfoMap.put("information_schema", InformationSchema.getSchemaTables().values().stream().map(table -> {
                    TTableInfo info = new TTableInfo(table.getTableName(), table.getPropValue("ttl").orElse("INF"));
                    info.setState(TableNodeStatus.USING.ordinal());
                    return info;
                }).collect(Collectors.toList()));
                this.dbIterator = databaseTableInfoMap.entrySet().iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            this.columnBuilders[0].writeBinary(new Binary(this.dbName, TSFileConfig.STRING_CHARSET));
            this.columnBuilders[1].writeBinary(new Binary(this.currentTable.getTableName(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[2].writeBinary(new Binary(this.currentTable.getTTL(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[3].writeBinary(new Binary(TableNodeStatus.values()[this.currentTable.getState()].toString(), TSFileConfig.STRING_CHARSET));
            if (this.currentTable.isSetComment()) {
                this.columnBuilders[4].writeBinary(new Binary(this.currentTable.getComment(), TSFileConfig.STRING_CHARSET));
            } else {
                this.columnBuilders[4].appendNull();
            }
            this.resultBuilder.declarePosition();
            this.currentTable = null;
        }

        @Override
        public boolean hasNext() {
            while (Objects.isNull(this.currentTable)) {
                if (Objects.nonNull(this.tableInfoIterator) && this.tableInfoIterator.hasNext()) {
                    this.currentTable = this.tableInfoIterator.next();
                    return true;
                }
                if (!this.dbIterator.hasNext()) {
                    return false;
                }
                Map.Entry<String, List<TTableInfo>> entry = this.dbIterator.next();
                this.dbName = entry.getKey();
                this.tableInfoIterator = entry.getValue().iterator();
            }
            return true;
        }
    }

    private static class ColumnSupplier
    extends TsBlockSupplier {
        private Iterator<Map.Entry<String, Map<String, Pair<TsTable, Set<String>>>>> dbIterator;
        private Iterator<Map.Entry<String, Pair<TsTable, Set<String>>>> tableInfoIterator;
        private Iterator<TsTableColumnSchema> columnSchemaIterator;
        private String dbName;
        private String tableName;
        private Set<String> preDeletedColumns;

        private ColumnSupplier(List<TSDataType> dataTypes) {
            super(dataTypes);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                TDescTable4InformationSchemaResp resp = client.descTables4InformationSchema();
                Map<String, Map> resultMap = resp.getTableColumnInfoMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, tableEntry -> new Pair((Object)TsTableInternalRPCUtil.deserializeSingleTsTable((byte[])((TTableColumnInfo)tableEntry.getValue()).getTableInfo()), (Object)((TTableColumnInfo)tableEntry.getValue()).getPreDeletedColumns())))));
                resultMap.put("information_schema", InformationSchema.getSchemaTables().values().stream().collect(Collectors.toMap(TsTable::getTableName, table -> new Pair(table, Collections.emptySet()))));
                this.dbIterator = resultMap.entrySet().iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            TsTableColumnSchema schema = this.columnSchemaIterator.next();
            this.columnBuilders[0].writeBinary(new Binary(this.dbName, TSFileConfig.STRING_CHARSET));
            this.columnBuilders[1].writeBinary(new Binary(this.tableName, TSFileConfig.STRING_CHARSET));
            this.columnBuilders[2].writeBinary(new Binary(schema.getColumnName(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[3].writeBinary(new Binary(schema.getDataType().name(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[4].writeBinary(new Binary(schema.getColumnCategory().name(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[5].writeBinary(new Binary(this.preDeletedColumns.contains(schema.getColumnName()) ? "PRE_DELETE" : "USING", TSFileConfig.STRING_CHARSET));
            if (schema.getProps().containsKey("__comment")) {
                this.columnBuilders[6].writeBinary(new Binary((String)schema.getProps().get("__comment"), TSFileConfig.STRING_CHARSET));
            } else {
                this.columnBuilders[6].appendNull();
            }
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            block2: {
                if (!Objects.isNull(this.columnSchemaIterator) && this.columnSchemaIterator.hasNext()) break block2;
                while (Objects.isNull(this.tableInfoIterator) || !this.tableInfoIterator.hasNext()) {
                    if (!this.dbIterator.hasNext()) {
                        return false;
                    }
                    Map.Entry<String, Map<String, Pair<TsTable, Set<String>>>> entry = this.dbIterator.next();
                    this.dbName = entry.getKey();
                    this.tableInfoIterator = entry.getValue().entrySet().iterator();
                }
                Map.Entry<String, Pair<TsTable, Set<String>>> tableEntry = this.tableInfoIterator.next();
                this.tableName = tableEntry.getKey();
                this.preDeletedColumns = (Set)tableEntry.getValue().getRight();
                this.columnSchemaIterator = ((TsTable)tableEntry.getValue().getLeft()).getColumnList().iterator();
            }
            return true;
        }
    }

    private static class RegionSupplier
    extends TsBlockSupplier {
        private Iterator<TRegionInfo> iterator;

        private RegionSupplier(List<TSDataType> dataTypes) {
            super(dataTypes);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.iterator = client.showRegion(new TShowRegionReq().setIsTableModel(true).setDatabases(null)).getRegionInfoListIterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            TRegionInfo regionInfo = this.iterator.next();
            this.columnBuilders[0].writeInt(regionInfo.getConsensusGroupId().getId());
            this.columnBuilders[1].writeInt(regionInfo.getDataNodeId());
            if (regionInfo.getConsensusGroupId().getType().ordinal() == TConsensusGroupType.SchemaRegion.ordinal()) {
                this.columnBuilders[2].writeBinary(BytesUtils.valueOf((String)String.valueOf(TConsensusGroupType.SchemaRegion)));
            } else if (regionInfo.getConsensusGroupId().getType().ordinal() == TConsensusGroupType.DataRegion.ordinal()) {
                this.columnBuilders[2].writeBinary(BytesUtils.valueOf((String)String.valueOf(TConsensusGroupType.DataRegion)));
            }
            this.columnBuilders[3].writeBinary(BytesUtils.valueOf((String)(regionInfo.getStatus() == null ? "" : regionInfo.getStatus())));
            this.columnBuilders[4].writeBinary(BytesUtils.valueOf((String)regionInfo.getDatabase()));
            this.columnBuilders[5].writeInt(regionInfo.getSeriesSlots());
            this.columnBuilders[6].writeLong(regionInfo.getTimeSlots());
            this.columnBuilders[7].writeBinary(BytesUtils.valueOf((String)regionInfo.getClientRpcIp()));
            this.columnBuilders[8].writeInt(regionInfo.getClientRpcPort());
            this.columnBuilders[9].writeBinary(BytesUtils.valueOf((String)regionInfo.getInternalAddress()));
            this.columnBuilders[10].writeBinary(BytesUtils.valueOf((String)regionInfo.getRoleType()));
            this.columnBuilders[11].writeLong(regionInfo.getCreateTime());
            if (regionInfo.getConsensusGroupId().getType().ordinal() == TConsensusGroupType.DataRegion.ordinal()) {
                this.columnBuilders[12].writeLong(regionInfo.getTsFileSize());
            } else {
                this.columnBuilders[12].appendNull();
            }
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    private static class PipeSupplier
    extends TsBlockSupplier {
        private Iterator<TShowPipeInfo> iterator;

        private PipeSupplier(List<TSDataType> dataTypes) {
            super(dataTypes);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.iterator = client.showPipe(new TShowPipeReq().setIsTableModel(true)).getPipeInfoListIterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            TShowPipeInfo tPipeInfo = this.iterator.next();
            this.columnBuilders[0].writeBinary(new Binary(tPipeInfo.getId(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[1].writeLong(TimestampPrecisionUtils.convertToCurrPrecision(tPipeInfo.getCreationTime(), TimeUnit.MILLISECONDS));
            this.columnBuilders[2].writeBinary(new Binary(tPipeInfo.getState(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[3].writeBinary(new Binary(tPipeInfo.getPipeExtractor(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[4].writeBinary(new Binary(tPipeInfo.getPipeProcessor(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[5].writeBinary(new Binary(tPipeInfo.getPipeConnector(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[6].writeBinary(new Binary(tPipeInfo.getExceptionMessage(), TSFileConfig.STRING_CHARSET));
            long remainingEventCount = tPipeInfo.getRemainingEventCount();
            double remainingTime = tPipeInfo.getEstimatedRemainingTime();
            if (remainingEventCount == -1L && remainingTime == -1.0) {
                Pair<Long, Double> remainingEventAndTime = PipeDataNodeRemainingEventAndTimeMetrics.getInstance().getRemainingEventAndTime(tPipeInfo.getId(), tPipeInfo.getCreationTime());
                remainingEventCount = (Long)remainingEventAndTime.getLeft();
                remainingTime = (Double)remainingEventAndTime.getRight();
            }
            this.columnBuilders[7].writeLong(tPipeInfo.isSetRemainingEventCount() ? remainingEventCount : -1L);
            this.columnBuilders[8].writeDouble(tPipeInfo.isSetEstimatedRemainingTime() ? remainingTime : -1.0);
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    private static class PipePluginSupplier
    extends TsBlockSupplier {
        private Iterator<PipePluginMeta> iterator;

        private PipePluginSupplier(List<TSDataType> dataTypes) {
            super(dataTypes);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.iterator = client.getPipePluginTable().getAllPipePluginMeta().stream().map(PipePluginMeta::deserialize).filter(pipePluginMeta -> !BuiltinPipePlugin.SHOW_PIPE_PLUGINS_BLACKLIST.contains(pipePluginMeta.getPluginName())).iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            PipePluginMeta pipePluginMeta = this.iterator.next();
            this.columnBuilders[0].writeBinary(BytesUtils.valueOf((String)pipePluginMeta.getPluginName()));
            this.columnBuilders[1].writeBinary(pipePluginMeta.isBuiltin() ? ShowPipePluginsTask.PIPE_PLUGIN_TYPE_BUILTIN : ShowPipePluginsTask.PIPE_PLUGIN_TYPE_EXTERNAL);
            this.columnBuilders[2].writeBinary(BytesUtils.valueOf((String)pipePluginMeta.getClassName()));
            if (Objects.nonNull(pipePluginMeta.getJarName())) {
                this.columnBuilders[3].writeBinary(BytesUtils.valueOf((String)pipePluginMeta.getJarName()));
            } else {
                this.columnBuilders[3].appendNull();
            }
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    private static class TopicSupplier
    extends TsBlockSupplier {
        private Iterator<TShowTopicInfo> iterator;

        private TopicSupplier(List<TSDataType> dataTypes) {
            super(dataTypes);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.iterator = client.showTopic(new TShowTopicReq().setIsTableModel(true)).getTopicInfoList().iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            TShowTopicInfo topicInfo = this.iterator.next();
            this.columnBuilders[0].writeBinary(new Binary(topicInfo.getTopicName(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[1].writeBinary(new Binary(topicInfo.getTopicAttributes(), TSFileConfig.STRING_CHARSET));
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    private static class SubscriptionSupplier
    extends TsBlockSupplier {
        private Iterator<TShowSubscriptionInfo> iterator;

        private SubscriptionSupplier(List<TSDataType> dataTypes) {
            super(dataTypes);
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                this.iterator = client.showSubscription(new TShowSubscriptionReq().setIsTableModel(true)).getSubscriptionInfoList().iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            TShowSubscriptionInfo tSubscriptionInfo = this.iterator.next();
            this.columnBuilders[0].writeBinary(new Binary(tSubscriptionInfo.getTopicName(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[1].writeBinary(new Binary(tSubscriptionInfo.getConsumerGroupId(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[2].writeBinary(new Binary(tSubscriptionInfo.getConsumerIds().toString(), TSFileConfig.STRING_CHARSET));
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    private static abstract class TsBlockSupplier
    implements Iterator<TsBlock> {
        protected final TsBlockBuilder resultBuilder;
        protected final ColumnBuilder[] columnBuilders;
        protected Exception lastException;

        private TsBlockSupplier(List<TSDataType> dataTypes) {
            this.resultBuilder = new TsBlockBuilder(dataTypes);
            this.columnBuilders = this.resultBuilder.getValueColumnBuilders();
        }

        @Override
        public TsBlock next() {
            if (Objects.nonNull(this.lastException)) {
                throw new NoSuchElementException(this.lastException.getMessage());
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            while (this.hasNext() && !this.resultBuilder.isFull()) {
                this.constructLine();
            }
            TsBlock result = this.resultBuilder.build((Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, this.resultBuilder.getPositionCount()));
            this.resultBuilder.reset();
            return result;
        }

        protected abstract void constructLine();
    }
}

