/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.JoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.MergeSortInnerJoinOperator;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;

public class AsofMergeSortInnerJoinOperator
extends MergeSortInnerJoinOperator {
    private final JoinKeyComparator asofComparator;
    private final int leftAsofJoinKeyIndex;
    private final int rightAsofJoinKeyIndex;

    public AsofMergeSortInnerJoinOperator(OperatorContext operatorContext, Operator leftChild, int[] leftJoinKeyPositions, int[] leftOutputSymbolIdx, Operator rightChild, int[] rightJoinKeyPositions, int[] rightOutputSymbolIdx, List<JoinKeyComparator> joinKeyComparators, List<TSDataType> dataTypes) {
        super(operatorContext, leftChild, leftJoinKeyPositions, leftOutputSymbolIdx, rightChild, rightJoinKeyPositions, rightOutputSymbolIdx, joinKeyComparators, dataTypes);
        this.asofComparator = joinKeyComparators.get(joinKeyComparators.size() - 1);
        this.leftAsofJoinKeyIndex = leftJoinKeyPositions[leftJoinKeyPositions.length - 1];
        this.rightAsofJoinKeyIndex = rightJoinKeyPositions[rightJoinKeyPositions.length - 1];
    }

    @Override
    protected boolean processFinished() {
        if (this.allRightLessOrEqualThanLeft()) {
            this.resetRightBlockList();
            return true;
        }
        while (this.currentLeftHasNullValue()) {
            if (!this.leftFinishedWithIncIndex()) continue;
            return true;
        }
        while (this.currentRightHasNullValue()) {
            if (!this.rightFinishedWithIncIndex()) continue;
            return true;
        }
        while (this.lessThanOrEqual((TsBlock)this.rightBlockList.get(this.rightBlockListIdx), this.rightJoinKeyPositions, this.rightIndex, this.leftBlock, this.leftJoinKeyPositions, this.leftIndex)) {
            if (!this.rightFinishedWithIncIndex()) continue;
            return true;
        }
        if (this.currentRoundNeedStop()) {
            return true;
        }
        this.hasMatchedRightValueToProbeLeft();
        return this.leftFinishedWithIncIndex();
    }

    protected boolean allRightLessOrEqualThanLeft() {
        return this.lessThanOrEqual((TsBlock)this.rightBlockList.get(this.rightBlockList.size() - 1), this.rightJoinKeyPositions, ((TsBlock)this.rightBlockList.get(this.rightBlockList.size() - 1)).getPositionCount() - 1, this.leftBlock, this.leftJoinKeyPositions, this.leftIndex);
    }

    private boolean lessThanOrEqual(TsBlock leftBlock, int[] leftPositions, int lIndex, TsBlock rightBlock, int[] rightPositions, int rIndex) {
        if (rightPositions.length == 1 && rightBlock.getColumn(rightPositions[0]).isNull(rIndex)) {
            return true;
        }
        int lastIndex = this.comparators.size() - 1;
        for (int i = 0; i < lastIndex; ++i) {
            if (((JoinKeyComparator)this.comparators.get(i)).lessThan(leftBlock, leftPositions[i], lIndex, rightBlock, rightPositions[i], rIndex).orElse(false).booleanValue()) {
                return true;
            }
            if (((JoinKeyComparator)this.comparators.get(i)).equalsTo(leftBlock, leftPositions[i], lIndex, rightBlock, rightPositions[i], rIndex).orElse(false).booleanValue()) continue;
            return false;
        }
        return ((JoinKeyComparator)this.comparators.get(lastIndex)).lessThanOrEqual(leftBlock, leftPositions[lastIndex], lIndex, rightBlock, rightPositions[lastIndex], rIndex).orElse(false);
    }

    @Override
    protected boolean currentRoundNeedStop() {
        if (this.rightBlockListIdx > 0) {
            for (int i = 0; i < this.rightBlockListIdx; ++i) {
                long size = ((TsBlock)this.rightBlockList.get(i)).getRetainedSizeInBytes();
                this.usedMemory -= size;
                this.memoryReservationManager.releaseMemoryCumulatively(size);
            }
            this.rightBlockList = this.rightBlockList.subList(this.rightBlockListIdx, this.rightBlockList.size());
            this.rightBlockListIdx = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMatchedRightValueToProbeLeft() {
        int tmpBlockIdx = this.rightBlockListIdx;
        int tmpIdx = this.rightIndex;
        boolean hasMatched = false;
        long matchedTime = Long.MIN_VALUE;
        while (this.equalsIgnoreAsof(this.leftBlock, this.leftJoinKeyPositions, this.leftIndex, (TsBlock)this.rightBlockList.get(tmpBlockIdx), this.rightJoinKeyPositions, tmpIdx) && this.asofComparator.lessThan(this.leftBlock, this.leftAsofJoinKeyIndex, this.leftIndex, (TsBlock)this.rightBlockList.get(this.rightBlockListIdx), this.rightAsofJoinKeyIndex, this.rightIndex).orElse(false).booleanValue()) {
            long currentTime = ((TsBlock)this.rightBlockList.get(tmpBlockIdx)).getColumn(this.rightAsofJoinKeyIndex).getLong(tmpIdx);
            if (matchedTime == Long.MIN_VALUE) {
                matchedTime = currentTime;
            } else if (currentTime != matchedTime) break;
            hasMatched = true;
            this.appendValueToResultWhenMatches(tmpBlockIdx, tmpIdx);
            if (++tmpIdx >= ((TsBlock)this.rightBlockList.get(tmpBlockIdx)).getPositionCount()) {
                tmpIdx = 0;
                ++tmpBlockIdx;
            }
            if (tmpBlockIdx < this.rightBlockList.size()) continue;
            break;
        }
        return hasMatched;
    }

    protected boolean equalsIgnoreAsof(TsBlock leftBlock, int[] leftPositions, int lIndex, TsBlock rightBlock, int[] rightPositions, int rIndex) {
        for (int i = 0; i < this.comparators.size() - 1; ++i) {
            if (((JoinKeyComparator)this.comparators.get(i)).equalsTo(leftBlock, leftPositions[i], lIndex, rightBlock, rightPositions[i], rIndex).orElse(false).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

