/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.function.rank;

import org.apache.iotdb.db.queryengine.execution.operator.process.window.function.rank.RankWindowFunction;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.tsfile.block.column.ColumnBuilder;

public class NTileFunction
extends RankWindowFunction {
    private final int n;

    public NTileFunction(int n) {
        this.n = n;
    }

    @Override
    public void transform(Partition partition, ColumnBuilder builder, int index, boolean isNewPeerGroup, int peerGroupCount) {
        builder.writeLong(this.bucket(this.n, index, partition.getPositionCount()) + 1L);
    }

    private long bucket(long buckets, int index, int count) {
        if ((long)count < buckets) {
            return index;
        }
        long rowsPerBucket = (long)count / buckets;
        long remainderRows = (long)count % buckets;
        if ((long)index < (rowsPerBucket + 1L) * remainderRows) {
            return (long)index / (rowsPerBucket + 1L);
        }
        return ((long)index - remainderRows) / rowsPerBucket;
    }

    @Override
    public boolean needPeerGroup() {
        return false;
    }
}

