/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations;

import java.util.HashSet;
import java.util.Map;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.DeviceTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FilterNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.GapFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.InformationSchemaTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LimitNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LinearFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.PreviousFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.StreamSortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableFunctionProcessorNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TopKNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PushPredicateIntoTableScan;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;

public class PushLimitOffsetIntoTableScan
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, PlanOptimizer.Context context) {
        if (!context.getAnalysis().isQuery()) {
            return plan;
        }
        return plan.accept(new Rewriter(context.getAnalysis()), new Context());
    }

    private static class Rewriter
    extends PlanVisitor<PlanNode, Context> {
        private final Analysis analysis;

        public Rewriter(Analysis analysis) {
            this.analysis = analysis;
        }

        @Override
        public PlanNode visitPlan(PlanNode node, Context context) {
            PlanNode newNode = node.clone();
            for (PlanNode child : node.getChildren()) {
                newNode.addChild(child.accept(this, context));
            }
            return newNode;
        }

        @Override
        public PlanNode visitJoin(JoinNode node, Context context) {
            PlanNode leftChild = node.getLeftChild().accept(this, new Context());
            PlanNode rightChild = node.getRightChild().accept(this, new Context());
            node.setLeftChild(leftChild);
            node.setRightChild(rightChild);
            context.enablePushDown = false;
            return node;
        }

        @Override
        public PlanNode visitFilter(FilterNode node, Context context) {
            if (node.getChild() instanceof DeviceTableScanNode || node.getChild() instanceof ProjectNode && ((ProjectNode)node.getChild()).getChild() instanceof DeviceTableScanNode) {
                context.enablePushDown = false;
                return node;
            }
            node.setChild(node.getChild().accept(this, context));
            return node;
        }

        @Override
        public PlanNode visitProject(ProjectNode node, Context context) {
            for (Expression expression : node.getAssignments().getMap().values()) {
                if (!PushPredicateIntoTableScan.containsDiffFunction(expression)) continue;
                context.enablePushDown = false;
                return node;
            }
            node.setChild(node.getChild().accept(this, context));
            return node;
        }

        @Override
        public PlanNode visitGapFill(GapFillNode node, Context context) {
            context.enablePushDown = false;
            return node;
        }

        @Override
        public PlanNode visitLinearFill(LinearFillNode node, Context context) {
            context.enablePushDown = false;
            return node;
        }

        @Override
        public PlanNode visitPreviousFill(PreviousFillNode node, Context context) {
            if (node.getGroupingKeys().isPresent()) {
                context.enablePushDown = false;
                return node;
            }
            PlanNode newNode = node.clone();
            for (PlanNode child : node.getChildren()) {
                newNode.addChild(child.accept(this, context));
            }
            return newNode;
        }

        @Override
        public PlanNode visitLimit(LimitNode node, Context context) {
            Context subContext = new Context();
            node.setChild(node.getChild().accept(this, subContext));
            context.existLimitNode = true;
            if (!subContext.enablePushDown || subContext.existLimitNode) {
                context.enablePushDown = false;
                return node;
            }
            DeviceTableScanNode deviceTableScanNode = subContext.deviceTableScanNode;
            context.deviceTableScanNode = deviceTableScanNode;
            if (deviceTableScanNode != null) {
                deviceTableScanNode.setPushDownLimit(node.getCount());
            }
            return node;
        }

        @Override
        public PlanNode visitSort(SortNode node, Context context) {
            Context subContext = new Context();
            node.setChild(node.getChild().accept(this, subContext));
            context.existSortNode = true;
            if (!subContext.enablePushDown || subContext.existSortNode || subContext.existLimitNode) {
                context.enablePushDown = false;
                return node;
            }
            DeviceTableScanNode deviceTableScanNode = subContext.deviceTableScanNode;
            context.deviceTableScanNode = deviceTableScanNode;
            OrderingScheme orderingScheme = node.getOrderingScheme();
            Map<Symbol, ColumnSchema> tableColumnSchema = this.analysis.getTableColumnSchema(deviceTableScanNode.getQualifiedObjectName());
            HashSet<Symbol> sortSymbols = new HashSet<Symbol>();
            for (Symbol orderBy : orderingScheme.getOrderBy()) {
                if (deviceTableScanNode.isTimeColumn(orderBy)) break;
                if (!tableColumnSchema.containsKey(orderBy) || tableColumnSchema.get(orderBy).getColumnCategory() == TsTableColumnCategory.FIELD) {
                    context.enablePushDown = false;
                    return node;
                }
                sortSymbols.add(orderBy);
            }
            boolean pushLimitToEachDevice = false;
            for (Map.Entry<Symbol, ColumnSchema> entry : tableColumnSchema.entrySet()) {
                if (entry.getValue().getColumnCategory() != TsTableColumnCategory.TAG || sortSymbols.contains(entry.getKey())) continue;
                pushLimitToEachDevice = true;
                break;
            }
            deviceTableScanNode.setPushLimitToEachDevice(pushLimitToEachDevice);
            return node;
        }

        @Override
        public PlanNode visitStreamSort(StreamSortNode node, Context context) {
            return this.visitSort((SortNode)node, context);
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, Context context) {
            context.enablePushDown = false;
            return node;
        }

        @Override
        public PlanNode visitDeviceTableScan(DeviceTableScanNode node, Context context) {
            context.deviceTableScanNode = node;
            return node;
        }

        @Override
        public PlanNode visitInformationSchemaTableScan(InformationSchemaTableScanNode node, Context context) {
            context.enablePushDown = false;
            return node;
        }

        @Override
        public PlanNode visitTableFunctionProcessor(TableFunctionProcessorNode node, Context context) {
            context.enablePushDown = false;
            if (node.getChild() != null) {
                Context subContext = new Context();
                node.setChild(node.getChild().accept(this, subContext));
            }
            return node;
        }

        @Override
        public PlanNode visitTopK(TopKNode node, Context context) {
            throw new IllegalStateException("TopKNode must be appeared after PushLimitOffsetIntoTableScan");
        }
    }

    private static class Context {
        private boolean enablePushDown = true;
        private DeviceTableScanNode deviceTableScanNode;
        private boolean existSortNode = false;
        private boolean existLimitNode = false;

        private Context() {
        }
    }
}

