/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata;

import java.util.List;
import java.util.Optional;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.db.exception.load.LoadAnalyzeTableColumnDisorderException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.relational.function.OperatorType;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ITableDeviceSchemaValidation;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.OperatorNotFoundException;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeNotFoundException;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignature;
import org.apache.iotdb.udf.api.relational.TableFunction;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.type.Type;

public interface Metadata {
    public boolean tableExists(QualifiedObjectName var1);

    public Optional<TableSchema> getTableSchema(SessionInfo var1, QualifiedObjectName var2);

    public Type getOperatorReturnType(OperatorType var1, List<? extends Type> var2) throws OperatorNotFoundException;

    public Type getFunctionReturnType(String var1, List<? extends Type> var2);

    public boolean isAggregationFunction(SessionInfo var1, String var2, AccessControl var3);

    public Type getType(TypeSignature var1) throws TypeNotFoundException;

    public boolean canCoerce(Type var1, Type var2);

    public IPartitionFetcher getPartitionFetcher();

    public List<DeviceEntry> indexScan(QualifiedObjectName var1, List<Expression> var2, List<String> var3, MPPQueryContext var4);

    public Optional<TableSchema> validateTableHeaderSchema(String var1, TableSchema var2, MPPQueryContext var3, boolean var4, boolean var5) throws LoadAnalyzeTableColumnDisorderException;

    public void validateDeviceSchema(ITableDeviceSchemaValidation var1, MPPQueryContext var2);

    default public DataPartition getOrCreateDataPartition(List<DataPartitionQueryParam> dataPartitionQueryParams, String userName) {
        throw new UnsupportedOperationException();
    }

    public SchemaPartition getOrCreateSchemaPartition(String var1, List<IDeviceID> var2, String var3);

    public SchemaPartition getSchemaPartition(String var1, List<IDeviceID> var2);

    public SchemaPartition getSchemaPartition(String var1);

    public DataPartition getDataPartition(String var1, List<DataPartitionQueryParam> var2);

    public DataPartition getDataPartitionWithUnclosedTimeRange(String var1, List<DataPartitionQueryParam> var2);

    public TableFunction getTableFunction(String var1);
}

