/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.distribution;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.NodeDistribution;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SourceNode;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowTimeSeriesStatement;

public class NodeGroupContext {
    protected final MPPQueryContext queryContext;
    private final Map<PlanNodeId, NodeDistribution> nodeDistributionMap;
    private boolean isAlignByDevice;
    private TRegionReplicaSet mostlyUsedDataRegion;
    protected boolean hasExchangeNode;

    public NodeGroupContext(MPPQueryContext queryContext, Statement statement, PlanNode root) {
        this.queryContext = queryContext;
        this.nodeDistributionMap = new HashMap<PlanNodeId, NodeDistribution>();
        if (statement instanceof QueryStatement) {
            this.isAlignByDevice = ((QueryStatement)statement).isAlignByDevice();
            this.mostlyUsedDataRegion = this.getMostlyUsedDataRegion(root);
        } else if (statement instanceof ShowTimeSeriesStatement) {
            this.mostlyUsedDataRegion = this.getMostlyUsedDataRegion(root);
        }
        this.hasExchangeNode = false;
    }

    private TRegionReplicaSet getMostlyUsedDataRegion(PlanNode root) {
        HashMap<TRegionReplicaSet, Long> regionCountMap = new HashMap<TRegionReplicaSet, Long>();
        this.countRegionOfSourceNodes(root, regionCountMap);
        if (regionCountMap.isEmpty()) {
            return DataPartition.NOT_ASSIGNED;
        }
        return (TRegionReplicaSet)Collections.max(regionCountMap.entrySet(), Map.Entry.comparingByValue()).getKey();
    }

    private void countRegionOfSourceNodes(PlanNode root, Map<TRegionReplicaSet, Long> result) {
        TRegionReplicaSet regionReplicaSet;
        root.getChildren().forEach(child -> this.countRegionOfSourceNodes((PlanNode)child, result));
        if (root instanceof SourceNode && (regionReplicaSet = ((SourceNode)root).getRegionReplicaSet()) != DataPartition.NOT_ASSIGNED) {
            result.compute(regionReplicaSet, (region, count) -> count == null ? 1L : count + 1L);
        }
    }

    public void putNodeDistribution(PlanNodeId nodeId, NodeDistribution distribution) {
        this.nodeDistributionMap.put(nodeId, distribution);
    }

    public NodeDistribution getNodeDistribution(PlanNodeId nodeId) {
        return this.nodeDistributionMap.get(nodeId);
    }

    public boolean isAlignByDevice() {
        return this.isAlignByDevice;
    }

    public TRegionReplicaSet getMostlyUsedDataRegion() {
        return this.mostlyUsedDataRegion;
    }
}

