/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement;

import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;

public abstract class Statement
extends StatementNode {
    protected StatementType statementType = StatementType.NULL;
    protected boolean isDebug;

    protected Statement() {
    }

    public void setType(StatementType statementType) {
        this.statementType = statementType;
    }

    public StatementType getType() {
        return this.statementType;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean debug) {
        this.isDebug = debug;
    }

    public boolean isQuery() {
        return false;
    }

    public abstract List<PartialPath> getPaths();

    public TSStatus checkPermissionBeforeProcess(String userName) {
        return AuthorityChecker.getTSStatus(AuthorityChecker.SUPER_USER.equals(userName), "Only the admin user can perform this operation");
    }
}

