/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.unary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.queryengine.common.NodeRef;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class UnaryExpression
extends Expression {
    protected Expression expression;

    protected UnaryExpression(Expression expression) {
        this.expression = expression;
    }

    public final Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitUnaryExpression(this, context);
    }

    @Override
    public final boolean isConstantOperandInternal() {
        return this.expression.isConstantOperand();
    }

    @Override
    public final List<Expression> getExpressions() {
        return Collections.singletonList(this.expression);
    }

    @Override
    public final void constructUdfExecutors(Map<String, UDTFExecutor> expressionName2Executor, ZoneId zoneId) {
        this.expression.constructUdfExecutors(expressionName2Executor, zoneId);
    }

    @Override
    public final void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> inputLocations) {
        this.expression.bindInputLayerColumnIndexWithExpression(inputLocations);
        String digest = this.getExpressionString();
        if (inputLocations.containsKey(digest)) {
            this.inputColumnIndex = inputLocations.get(digest).get(0).getValueColumnIndex();
        }
    }

    @Override
    public final void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        this.expression.updateStatisticsForMemoryAssigner(memoryAssigner);
        memoryAssigner.increaseExpressionReference(this);
    }

    @Override
    public boolean isMappable(Map<NodeRef<Expression>, TSDataType> expressionTypes) {
        return this.expression.isMappable(expressionTypes);
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        Expression.serialize(this.expression, byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        Expression.serialize(this.expression, stream);
    }
}

