/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.TsFileInsertionDataContainer;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTsFileInsertionEvent
extends EnrichedEvent
implements TsFileInsertionEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTsFileInsertionEvent.class);
    private boolean isTsFileFormatValid = true;
    private final TsFileResource resource;
    private File tsFile;
    private final boolean isLoaded;
    private final boolean isGeneratedByPipe;
    private final AtomicBoolean isClosed;
    private TsFileInsertionDataContainer dataContainer;

    public PipeTsFileInsertionEvent(TsFileResource resource, boolean isLoaded, boolean isGeneratedByPipe) {
        this(resource, isLoaded, isGeneratedByPipe, null, null, null, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public PipeTsFileInsertionEvent(TsFileResource resource, boolean isLoaded, boolean isGeneratedByPipe, String pipeName, PipeTaskMeta pipeTaskMeta, String pattern, long startTime, long endTime) {
        super(pipeName, pipeTaskMeta, pattern, startTime, endTime);
        TsFileProcessor processor;
        this.resource = resource;
        this.tsFile = resource.getTsFile();
        this.isLoaded = isLoaded;
        this.isGeneratedByPipe = isGeneratedByPipe;
        this.isClosed = new AtomicBoolean(resource.isClosed());
        if (!this.isClosed.get() && (processor = resource.getProcessor()) != null) {
            processor.addCloseFileListener(o -> {
                AtomicBoolean atomicBoolean = this.isClosed;
                synchronized (atomicBoolean) {
                    this.isTsFileFormatValid = o.isTsFileFormatValidForPipe();
                    this.isClosed.set(true);
                    this.isClosed.notifyAll();
                }
            });
        }
        this.isClosed.set(resource.isClosed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForTsFileClose() throws InterruptedException {
        if (!this.isClosed.get()) {
            AtomicBoolean atomicBoolean = this.isClosed;
            synchronized (atomicBoolean) {
                while (!this.isClosed.get()) {
                    this.isClosed.wait();
                }
            }
        }
        return this.isTsFileFormatValid;
    }

    public File getTsFile() {
        return this.tsFile;
    }

    public boolean getIsLoaded() {
        return this.isLoaded;
    }

    public long getFileStartTime() {
        return this.resource.getFileStartTime();
    }

    @Override
    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        try {
            this.tsFile = PipeResourceManager.tsfile().increaseFileReference(this.tsFile, true);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Increase reference count for TsFile %s error. Holder Message: %s", this.tsFile.getPath(), holderMessage), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        try {
            PipeResourceManager.tsfile().decreaseFileReference(this.tsFile);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Decrease reference count for TsFile %s error. Holder Message: %s", this.tsFile.getPath(), holderMessage), (Throwable)e);
            return false;
        }
    }

    @Override
    public ProgressIndex getProgressIndex() {
        try {
            this.waitForTsFileClose();
            return this.resource.getMaxProgressIndexAfterClose();
        }
        catch (InterruptedException e) {
            LOGGER.warn(String.format("Interrupted when waiting for closing TsFile %s.", this.resource.getTsFilePath()));
            Thread.currentThread().interrupt();
            return MinimumProgressIndex.INSTANCE;
        }
    }

    @Override
    public PipeTsFileInsertionEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, PipeTaskMeta pipeTaskMeta, String pattern, long startTime, long endTime) {
        return new PipeTsFileInsertionEvent(this.resource, this.isLoaded, this.isGeneratedByPipe, pipeName, pipeTaskMeta, pattern, startTime, endTime);
    }

    @Override
    public boolean isGeneratedByPipe() {
        return this.isGeneratedByPipe;
    }

    @Override
    public boolean mayEventTimeOverlappedWithTimeRange() {
        return this.isClosed.get() ? this.startTime <= this.resource.getFileEndTime() && this.resource.getFileStartTime() <= this.endTime : this.resource.getFileStartTime() <= this.endTime;
    }

    public Iterable<TabletInsertionEvent> toTabletInsertionEvents() {
        try {
            if (this.dataContainer == null) {
                this.waitForTsFileClose();
                this.dataContainer = new TsFileInsertionDataContainer(this.tsFile, this.getPattern(), this.startTime, this.endTime, this.pipeTaskMeta, this);
            }
            return this.dataContainer.toTabletInsertionEvents();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.close();
            String errorMsg = String.format("Interrupted when waiting for closing TsFile %s.", this.resource.getTsFilePath());
            LOGGER.warn(errorMsg, (Throwable)e);
            throw new PipeException(errorMsg);
        }
        catch (IOException e) {
            this.close();
            String errorMsg = String.format("Read TsFile %s error.", this.resource.getTsFilePath());
            LOGGER.warn(errorMsg, (Throwable)e);
            throw new PipeException(errorMsg);
        }
    }

    public void close() {
        if (this.dataContainer != null) {
            this.dataContainer.close();
            this.dataContainer = null;
        }
    }

    @Override
    public String toString() {
        return String.format("PipeTsFileInsertionEvent{isTsFileFormatValid=%s, resource=%s, tsFile=%s, isLoaded=%s, isGeneratedByPipe=%s, isClosed=%s, dataContainer=%s}", this.isTsFileFormatValid, this.resource, this.tsFile, this.isLoaded, this.isGeneratedByPipe, this.isClosed.get(), this.dataContainer) + " - " + super.toString();
    }
}

