/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema.table;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteDevicesPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeEnrichedPlan;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeRegionTaskExecutor;
import org.apache.iotdb.confignode.procedure.impl.schema.table.AbstractAlterOrDropTableProcedure;
import org.apache.iotdb.confignode.procedure.state.schema.DeleteDevicesState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.mpp.rpc.thrift.TTableDeviceDeletionWithPatternAndFilterReq;
import org.apache.iotdb.mpp.rpc.thrift.TTableDeviceDeletionWithPatternOrModReq;
import org.apache.iotdb.mpp.rpc.thrift.TTableDeviceInvalidateCacheReq;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteDevicesProcedure
extends AbstractAlterOrDropTableProcedure<DeleteDevicesState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteDevicesProcedure.class);
    private byte[] patternBytes;
    private byte[] filterBytes;
    private byte[] modBytes;
    private long deletedDevicesNum;

    public DeleteDevicesProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public DeleteDevicesProcedure(String database, String tableName, String queryId, @Nonnull byte[] patternBytes, @Nonnull byte[] filterBytes, @Nonnull byte[] modBytes, boolean isGeneratedByPipe) {
        super(database, tableName, queryId, isGeneratedByPipe);
        this.patternBytes = patternBytes;
        this.filterBytes = filterBytes;
        this.modBytes = modBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, DeleteDevicesState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        long startTime = System.currentTimeMillis();
        try {
            switch (state) {
                case CHECK_TABLE_EXISTENCE: {
                    LOGGER.info("Check the existence of table {}.{}", (Object)this.database, (Object)this.tableName);
                    this.checkTableExistence(env);
                    break;
                }
                case CONSTRUCT_BLACK_LIST: {
                    LOGGER.info("Construct schemaEngine black list of devices in {}.{}", (Object)this.database, (Object)this.tableName);
                    this.constructBlackList(env);
                    if (this.deletedDevicesNum > 0L) {
                        this.setNextState(DeleteDevicesState.CLEAN_DATANODE_SCHEMA_CACHE);
                        break;
                    }
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
                case CLEAN_DATANODE_SCHEMA_CACHE: {
                    LOGGER.info("Invalidate cache of devices in {}.{}", (Object)this.database, (Object)this.tableName);
                    this.invalidateCache(env);
                    break;
                }
                case DELETE_DATA: {
                    LOGGER.info("Delete data of devices in {}.{}", (Object)this.database, (Object)this.tableName);
                    this.deleteData(env);
                    break;
                }
                case DELETE_DEVICE_SCHEMA: {
                    LOGGER.info("Delete devices in {}.{} in schemaEngine", (Object)this.database, (Object)this.tableName);
                    this.deleteDeviceSchema(env);
                    this.collectPayload4Pipe(env);
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
                default: {
                    this.setFailure(new ProcedureException("Unrecognized state " + (Object)((Object)state)));
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
            }
            StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.HAS_MORE_STATE;
            return flow;
        }
        finally {
            LOGGER.info("DeleteDevices-[{}] costs {}ms", (Object)state, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private void checkTableExistence(ConfigNodeProcedureEnv env) {
        try {
            if (!env.getConfigManager().getClusterSchemaManager().getTableIfExists(this.database, this.tableName).isPresent()) {
                this.setFailure(new ProcedureException((Throwable)new IoTDBException(String.format("Table '%s.%s' not exists.", this.database, this.tableName), TSStatusCode.TABLE_NOT_EXISTS.getStatusCode())));
            } else {
                this.setNextState(DeleteDevicesState.CONSTRUCT_BLACK_LIST);
            }
        }
        catch (MetadataException e) {
            this.setFailure(new ProcedureException(e));
        }
    }

    private void constructBlackList(ConfigNodeProcedureEnv env) {
        Map<TConsensusGroupId, TRegionReplicaSet> relatedSchemaRegionGroup = env.getConfigManager().getRelatedSchemaRegionGroup4TableModel(this.database);
        if (relatedSchemaRegionGroup.isEmpty()) {
            this.deletedDevicesNum = 0L;
            return;
        }
        final ArrayList successResult = new ArrayList();
        new DataNodeRegionTaskExecutor<TTableDeviceDeletionWithPatternAndFilterReq, TSStatus>(env, relatedSchemaRegionGroup, false, CnToDnAsyncRequestType.CONSTRUCT_TABLE_DEVICE_BLACK_LIST, (dataNodeLocation, consensusGroupIdList) -> new TTableDeviceDeletionWithPatternAndFilterReq(new ArrayList(consensusGroupIdList), this.tableName, ByteBuffer.wrap(this.patternBytes), ByteBuffer.wrap(this.filterBytes))){

            @Override
            protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TSStatus response) {
                ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
                if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    successResult.add(response);
                } else if (response.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    List subStatusList = response.getSubStatus();
                    for (int i = 0; i < subStatusList.size(); ++i) {
                        if (((TSStatus)subStatusList.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            successResult.add((TSStatus)subStatusList.get(i));
                            continue;
                        }
                        failedRegionList.add(consensusGroupIdList.get(i));
                    }
                } else {
                    failedRegionList.addAll(consensusGroupIdList);
                }
                return failedRegionList;
            }

            @Override
            protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId, Set<TDataNodeLocation> dataNodeLocationSet) {
                DeleteDevicesProcedure.this.setFailure(new ProcedureException(new MetadataException(String.format("[%s] for %s.%s failed when construct black list for table because failed to execute in all replicaset of %s %s. Failure nodes: %s", this.getClass().getSimpleName(), DeleteDevicesProcedure.this.database, DeleteDevicesProcedure.this.tableName, consensusGroupId.type, consensusGroupId.id, dataNodeLocationSet))));
                this.interruptTask();
            }
        }.execute();
        this.setNextState(DeleteDevicesState.CONSTRUCT_BLACK_LIST);
        this.deletedDevicesNum = !this.isFailed() ? successResult.stream().mapToLong(resp -> Long.parseLong(resp.getMessage())).reduce(Long::sum).orElse(0L) : 0L;
    }

    private void invalidateCache(ConfigNodeProcedureEnv env) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.INVALIDATE_MATCHED_TABLE_DEVICE_CACHE, new TTableDeviceInvalidateCacheReq(this.database, this.tableName, ByteBuffer.wrap(this.patternBytes)), dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (TSStatus status : statusMap.values()) {
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.error("Failed to invalidate schemaEngine cache of devices in table {}.{}", (Object)this.database, (Object)this.tableName);
            this.setFailure(new ProcedureException(new MetadataException("Invalidate schemaEngine cache failed")));
            return;
        }
        this.setNextState(DeleteDevicesState.DELETE_DATA);
    }

    private void deleteData(ConfigNodeProcedureEnv env) {
        new AbstractAlterOrDropTableProcedure.TableRegionTaskExecutor<TTableDeviceDeletionWithPatternOrModReq>("delete data for table device", env, env.getConfigManager().getRelatedDataRegionGroup4TableModel(this.database), CnToDnAsyncRequestType.DELETE_DATA_FOR_TABLE_DEVICE, (dataNodeLocation, consensusGroupIdList) -> new TTableDeviceDeletionWithPatternOrModReq(consensusGroupIdList, this.tableName, ByteBuffer.wrap(this.modBytes))).execute();
        this.setNextState(DeleteDevicesState.DELETE_DEVICE_SCHEMA);
    }

    private void deleteDeviceSchema(ConfigNodeProcedureEnv env) {
        new AbstractAlterOrDropTableProcedure.TableRegionTaskExecutor<TTableDeviceDeletionWithPatternOrModReq>("roll back table device black list", env, env.getConfigManager().getRelatedSchemaRegionGroup4TableModel(this.database), CnToDnAsyncRequestType.DELETE_TABLE_DEVICE_IN_BLACK_LIST, (dataNodeLocation, consensusGroupIdList) -> new TTableDeviceDeletionWithPatternOrModReq(consensusGroupIdList, this.tableName, ByteBuffer.wrap(this.patternBytes))).execute();
    }

    private void collectPayload4Pipe(ConfigNodeProcedureEnv env) {
        TSStatus result;
        try {
            result = env.getConfigManager().getConsensusManager().write(this.isGeneratedByPipe ? new PipeEnrichedPlan(new PipeDeleteDevicesPlan(this.database, this.tableName, this.patternBytes, this.filterBytes, this.modBytes)) : new PipeDeleteDevicesPlan(this.database, this.tableName, this.patternBytes, this.filterBytes, this.modBytes));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            result = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            result.setMessage(e.getMessage());
        }
        if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(result.getMessage());
        }
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, DeleteDevicesState deleteDevicesState) throws IOException, InterruptedException, ProcedureException {
        if (deleteDevicesState == DeleteDevicesState.CONSTRUCT_BLACK_LIST) {
            new AbstractAlterOrDropTableProcedure.TableRegionTaskExecutor<TTableDeviceDeletionWithPatternOrModReq>("roll back table device black list", env, env.getConfigManager().getRelatedSchemaRegionGroup4TableModel(this.database), CnToDnAsyncRequestType.ROLLBACK_TABLE_DEVICE_BLACK_LIST, (dataNodeLocation, consensusGroupIdList) -> new TTableDeviceDeletionWithPatternOrModReq(consensusGroupIdList, this.tableName, ByteBuffer.wrap(this.patternBytes))).execute();
        }
    }

    public long getDeletedDevicesNum() {
        return this.deletedDevicesNum;
    }

    @Override
    protected DeleteDevicesState getState(int stateId) {
        return DeleteDevicesState.values()[stateId];
    }

    @Override
    protected int getStateId(DeleteDevicesState deleteDevicesState) {
        return deleteDevicesState.ordinal();
    }

    @Override
    protected DeleteDevicesState getInitialState() {
        return DeleteDevicesState.CHECK_TABLE_EXISTENCE;
    }

    @Override
    protected String getActionMessage() {
        return null;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_DELETE_DEVICES_PROCEDURE.getTypeCode() : ProcedureType.DELETE_DEVICES_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((int)this.patternBytes.length, (OutputStream)stream);
        stream.write(this.patternBytes);
        ReadWriteIOUtils.write((int)this.filterBytes.length, (OutputStream)stream);
        stream.write(this.filterBytes);
        ReadWriteIOUtils.write((int)this.modBytes.length, (OutputStream)stream);
        stream.write(this.modBytes);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.patternBytes = new byte[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        byteBuffer.get(this.patternBytes);
        this.filterBytes = new byte[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        byteBuffer.get(this.filterBytes);
        this.modBytes = new byte[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        byteBuffer.get(this.modBytes);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Arrays.equals(this.patternBytes, ((DeleteDevicesProcedure)o).patternBytes) && Arrays.equals(this.filterBytes, ((DeleteDevicesProcedure)o).filterBytes) && Arrays.equals(this.modBytes, ((DeleteDevicesProcedure)o).modBytes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.patternBytes), Arrays.hashCode(this.filterBytes), Arrays.hashCode(this.modBytes));
    }
}

