/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure;

import java.util.List;
import java.util.TreeMap;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.confignode.consensus.request.write.partition.AutoCleanPartitionTablePlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.procedure.InternalProcedure;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionTableAutoCleaner<Env>
extends InternalProcedure<Env> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionTableAutoCleaner.class);
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private final ConfigManager configManager;

    public PartitionTableAutoCleaner(ConfigManager configManager) {
        super(COMMON_CONFIG.getTTLCheckInterval());
        this.configManager = configManager;
        LOGGER.info("[PartitionTableCleaner] The PartitionTableAutoCleaner is started with cycle={}ms", (Object)COMMON_CONFIG.getTTLCheckInterval());
    }

    @Override
    protected void periodicExecute(Env env) {
        List<String> databases = this.configManager.getClusterSchemaManager().getDatabaseNames(null);
        TreeMap<String, Long> databaseTTLMap = new TreeMap<String, Long>();
        for (String database : databases) {
            long databaseTTL = PathUtils.isTableModelDatabase((String)database) ? this.configManager.getClusterSchemaManager().getDatabaseMaxTTL(database) : this.configManager.getTTLManager().getDatabaseMaxTTL(database);
            databaseTTLMap.put(database, databaseTTL);
            if (this.configManager.getPartitionManager().isDatabaseExist(database) && databaseTTL >= 0L && databaseTTL != Long.MAX_VALUE) continue;
            databaseTTLMap.remove(database);
        }
        if (!databaseTTLMap.isEmpty()) {
            LOGGER.info("[PartitionTableCleaner] Periodically activate PartitionTableAutoCleaner for: {}", databaseTTLMap);
            TTimePartitionSlot currentTimePartitionSlot = TimePartitionUtils.getCurrentTimePartitionSlot();
            try {
                this.configManager.getConsensusManager().write(new AutoCleanPartitionTablePlan(databaseTTLMap, currentTimePartitionSlot));
            }
            catch (ConsensusException e) {
                LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            }
        }
    }
}

