/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.relational.EmptyTableFunctionHandle;
import org.apache.iotdb.udf.api.relational.TableFunction;
import org.apache.iotdb.udf.api.relational.table.TableFunctionAnalysis;
import org.apache.iotdb.udf.api.relational.table.TableFunctionHandle;
import org.apache.iotdb.udf.api.relational.table.TableFunctionProcessorProvider;
import org.apache.iotdb.udf.api.relational.table.argument.Argument;
import org.apache.iotdb.udf.api.relational.table.argument.DescribedSchema;
import org.apache.iotdb.udf.api.relational.table.argument.ScalarArgument;
import org.apache.iotdb.udf.api.relational.table.argument.TableArgument;
import org.apache.iotdb.udf.api.relational.table.processor.TableFunctionDataProcessor;
import org.apache.iotdb.udf.api.relational.table.specification.ParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.ScalarParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.TableParameterSpecification;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.ColumnBuilder;

public class MySelectColumn
implements TableFunction {
    private final String TBL_PARAM = "DATA";
    private final String COL_PARAM = "SELECT";

    public List<ParameterSpecification> getArgumentsSpecifications() {
        return Arrays.asList(TableParameterSpecification.builder().name("DATA").build(), ScalarParameterSpecification.builder().name("SELECT").type(Type.STRING).build());
    }

    public TableFunctionAnalysis analyze(Map<String, Argument> arguments) throws UDFException {
        TableArgument tableArgument = (TableArgument)arguments.get("DATA");
        String selectColumn = (String)((ScalarArgument)arguments.get("SELECT")).getValue();
        ArrayList<Integer> requiredColumns = new ArrayList<Integer>();
        DescribedSchema.Builder schemaBuilder = DescribedSchema.builder();
        for (int i = 0; i < tableArgument.getFieldNames().size(); ++i) {
            Optional fieldName = (Optional)tableArgument.getFieldNames().get(i);
            if (!fieldName.isPresent() || !((String)fieldName.get()).equalsIgnoreCase(selectColumn)) continue;
            requiredColumns.add(i);
            schemaBuilder.addField(fieldName, (Type)tableArgument.getFieldTypes().get(i));
        }
        return TableFunctionAnalysis.builder().properColumnSchema(schemaBuilder.build()).requiredColumns("DATA", requiredColumns).handle((TableFunctionHandle)new EmptyTableFunctionHandle()).build();
    }

    public TableFunctionHandle createTableFunctionHandle() {
        return new EmptyTableFunctionHandle();
    }

    public TableFunctionProcessorProvider getProcessorProvider(TableFunctionHandle tableFunctionHandle) {
        return new TableFunctionProcessorProvider(){

            public TableFunctionDataProcessor getDataProcessor() {
                return (input, properColumnBuilders, passThroughIndexBuilder) -> {
                    for (int i = 0; i < input.size(); ++i) {
                        if (input.isNull(i)) {
                            ((ColumnBuilder)properColumnBuilders.get(i)).appendNull();
                            continue;
                        }
                        ((ColumnBuilder)properColumnBuilders.get(i)).writeObject(input.getObject(i));
                    }
                };
            }
        };
    }
}

