/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.it.env.cluster.config;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public abstract class MppBaseConfig {
    public static final String NULL_VALUE = "";
    protected final Properties properties = new Properties();

    protected MppBaseConfig() {
    }

    protected MppBaseConfig(String filePath) throws IOException {
        this();
        this.updateProperties(filePath);
    }

    public final void updateProperties(@NotNull Properties properties) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.setProperty((String)k, (String)v)));
    }

    public void updateProperties(@NotNull MppBaseConfig persistentConfig) {
        this.updateProperties(persistentConfig.properties);
    }

    public final void updateProperties(@Nullable String filePath) throws IOException {
        if (filePath == null) {
            return;
        }
        try (InputStream confInput = Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);){
            this.properties.load(new InputStreamReader(confInput, StandardCharsets.UTF_8));
        }
    }

    public final void persistent(String filePath) throws IOException {
        try (FileWriter confOutput = new FileWriter(filePath, true);){
            this.properties.store(confOutput, null);
        }
    }

    protected final void setProperty(@NotNull String key, String value) {
        if (!value.equals(NULL_VALUE)) {
            this.properties.setProperty(key, value);
        } else {
            this.properties.remove(key);
        }
    }

    public abstract MppBaseConfig emptyClone();
}

