/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example;

import java.nio.ByteBuffer;
import org.apache.iotdb.udf.api.State;
import org.apache.iotdb.udf.api.UDAF;
import org.apache.iotdb.udf.api.customizer.config.UDAFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.iotdb.udf.api.utils.ResultValue;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class UDAFSum
implements UDAF {
    private Type dataType;

    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
    }

    public void beforeStart(UDFParameters parameters, UDAFConfigurations configurations) {
        this.dataType = parameters.getDataType(0);
        configurations.setOutputDataType(Type.DOUBLE);
    }

    public State createState() {
        return new SumState();
    }

    public void addInput(State state, Column[] columns, BitMap bitMap) {
        SumState sumState = (SumState)state;
        switch (this.dataType) {
            case INT32: {
                this.addIntInput(sumState, columns, bitMap);
                return;
            }
            case INT64: {
                this.addLongInput(sumState, columns, bitMap);
                return;
            }
            case FLOAT: {
                this.addFloatInput(sumState, columns, bitMap);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(sumState, columns, bitMap);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in aggregation AVG : %s", this.dataType));
    }

    public void combineState(State state, State rhs) {
        SumState sumState = (SumState)state;
        SumState sumRhs = (SumState)rhs;
        sumState.initResult |= sumRhs.initResult;
        sumState.sum += sumRhs.sum;
    }

    public void outputFinal(State state, ResultValue resultValue) {
        SumState sumState = (SumState)state;
        if (sumState.initResult) {
            resultValue.setDouble(sumState.sum);
        } else {
            resultValue.setNull();
        }
    }

    public void removeState(State state, State removed) {
        SumState sumState = (SumState)state;
        SumState sumRhs = (SumState)removed;
        sumState.sum -= sumRhs.sum;
    }

    private void addIntInput(SumState state, Column[] columns, BitMap bitMap) {
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || columns[0].isNull(i)) continue;
            state.initResult = true;
            state.sum += (double)columns[0].getInt(i);
        }
    }

    private void addLongInput(SumState state, Column[] columns, BitMap bitMap) {
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || columns[0].isNull(i)) continue;
            state.initResult = true;
            state.sum += (double)columns[0].getLong(i);
        }
    }

    private void addFloatInput(SumState state, Column[] columns, BitMap bitMap) {
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || columns[0].isNull(i)) continue;
            state.initResult = true;
            state.sum += (double)columns[0].getFloat(i);
        }
    }

    private void addDoubleInput(SumState state, Column[] columns, BitMap bitMap) {
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || columns[0].isNull(i)) continue;
            state.initResult = true;
            state.sum += columns[0].getDouble(i);
        }
    }

    static class SumState
    implements State {
        double sum = 0.0;
        boolean initResult = false;

        SumState() {
        }

        public void reset() {
            this.sum = 0.0;
            this.initResult = false;
        }

        public byte[] serialize() {
            ByteBuffer buffer = ByteBuffer.allocate(9);
            buffer.putDouble(this.sum);
            buffer.put(this.initResult ? (byte)1 : 0);
            return buffer.array();
        }

        public void deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            this.sum = buffer.getDouble();
            this.initResult = buffer.get() == 1;
        }
    }
}

