/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example;

import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlidingSizeWindowConstructorTester0
implements UDTF {
    private static final Logger logger = LoggerFactory.getLogger(SlidingSizeWindowConstructorTester0.class);

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        logger.debug("SlidingSizeWindowConstructorTester0#beforeStart");
        int windowSize = parameters.getInt("windowSize");
        int slidingStep = parameters.getInt("slidingStep");
        configurations.setOutputDataType(Type.INT32).setAccessStrategy((AccessStrategy)new SlidingSizeWindowAccessStrategy(windowSize, slidingStep));
    }

    public void transform(RowWindow rowWindow, PointCollector collector) throws Exception {
        if (rowWindow.windowSize() != 0) {
            collector.putInt(rowWindow.getRow(0).getTime(), rowWindow.windowSize());
        }
    }

    public void beforeDestroy() {
        logger.debug("SlidingSizeWindowConstructorTester0#beforeDestroy");
    }
}

