/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.it.env;

import org.apache.iotdb.it.env.EnvType;
import org.apache.iotdb.it.env.cluster.env.AIEnv;
import org.apache.iotdb.it.env.cluster.env.AbstractEnv;
import org.apache.iotdb.it.env.cluster.env.Cluster1Env;
import org.apache.iotdb.it.env.cluster.env.SimpleEnv;
import org.apache.iotdb.it.env.remote.env.RemoteServerEnv;
import org.apache.iotdb.it.framework.IoTDBTestLogger;
import org.apache.iotdb.itbase.env.BaseEnv;
import org.slf4j.Logger;

public class EnvFactory {
    private static BaseEnv env;
    private static final Logger logger;

    private EnvFactory() {
    }

    public static BaseEnv getEnv() {
        if (env == null) {
            try {
                Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
                logger.debug(">>>>>>>{}", (Object)System.getProperty("TestEnv"));
                EnvType envType = EnvType.getSystemEnvType();
                switch (envType) {
                    case Simple: {
                        env = new SimpleEnv();
                        break;
                    }
                    case Cluster1: {
                        env = new Cluster1Env();
                        break;
                    }
                    case Remote: {
                        env = new RemoteServerEnv();
                        break;
                    }
                    case AI: {
                        env = new AIEnv();
                        break;
                    }
                    case MultiCluster: {
                        logger.warn("EnvFactory only supports EnvType Simple, Cluster1 and Remote, please use MultiEnvFactory instead.");
                        System.exit(-1);
                        break;
                    }
                    default: {
                        logger.warn("Unknown env type: {}", (Object)envType);
                        System.exit(-1);
                        break;
                    }
                }
            }
            catch (ClassNotFoundException e) {
                logger.error("Get env error", (Throwable)e);
                System.exit(-1);
            }
        }
        return env;
    }

    public static AbstractEnv getAbstractEnv() {
        return (AbstractEnv)EnvFactory.getEnv();
    }

    static {
        logger = IoTDBTestLogger.logger;
    }
}

