/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example;

import java.nio.ByteBuffer;
import org.apache.iotdb.udf.api.State;
import org.apache.iotdb.udf.api.UDAF;
import org.apache.iotdb.udf.api.customizer.config.UDAFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.iotdb.udf.api.utils.ResultValue;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.utils.BitMap;

public class UDAFCount
implements UDAF {
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE, Type.BOOLEAN, Type.TEXT});
    }

    public void beforeStart(UDFParameters parameters, UDAFConfigurations configurations) {
        configurations.setOutputDataType(Type.INT64);
    }

    public State createState() {
        return new CountState();
    }

    public void addInput(State state, Column[] column, BitMap bitMap) {
        CountState countState = (CountState)state;
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[0].isNull(i)) continue;
            ++countState.count;
        }
    }

    public void combineState(State state, State rhs) {
        CountState countState = (CountState)state;
        CountState countRhs = (CountState)rhs;
        countState.count += countRhs.count;
    }

    public void outputFinal(State state, ResultValue resultValue) {
        CountState countState = (CountState)state;
        resultValue.setLong(countState.count);
    }

    public void removeState(State state, State removed) {
        CountState countState = (CountState)state;
        CountState countRhs = (CountState)removed;
        countState.count -= countRhs.count;
    }

    static class CountState
    implements State {
        long count;

        CountState() {
        }

        public void reset() {
            this.count = 0L;
        }

        public byte[] serialize() {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong(this.count);
            return buffer.array();
        }

        public void deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            this.count = buffer.getLong();
        }
    }
}

