/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example;

import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;

public class TwoSumBlock
implements UDTF {
    private Type type;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(2).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE}).validateInputSeriesDataType(1, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        this.type = parameters.getDataType(0);
        configurations.setAccessStrategy((AccessStrategy)new MappableRowByRowAccessStrategy()).setOutputDataType(this.type);
    }

    public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        switch (this.type) {
            case INT32: {
                this.transformInt(columns, builder);
                return;
            }
            case INT64: {
                this.transformLong(columns, builder);
                return;
            }
            case FLOAT: {
                this.transformFloat(columns, builder);
                return;
            }
            case DOUBLE: {
                this.transformDouble(columns, builder);
                return;
            }
        }
        throw new Exception();
    }

    public void transformInt(Column[] columns, ColumnBuilder builder) throws Exception {
        int[] inputs1 = columns[0].getInts();
        int[] inputs2 = columns[1].getInts();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            builder.writeInt(inputs1[i] + inputs2[i]);
        }
    }

    public void transformLong(Column[] columns, ColumnBuilder builder) throws Exception {
        long[] inputs1 = columns[0].getLongs();
        long[] inputs2 = columns[1].getLongs();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            builder.writeLong(inputs1[i] + inputs2[i]);
        }
    }

    public void transformFloat(Column[] columns, ColumnBuilder builder) throws Exception {
        float[] inputs1 = columns[0].getFloats();
        float[] inputs2 = columns[1].getFloats();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            builder.writeFloat(inputs1[i] + inputs2[i]);
        }
    }

    public void transformDouble(Column[] columns, ColumnBuilder builder) throws Exception {
        double[] inputs1 = columns[0].getDoubles();
        double[] inputs2 = columns[1].getDoubles();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            builder.writeDouble(inputs1[i] + inputs2[i]);
        }
    }
}

