/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example;

import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class TwoSum
implements UDTF {
    private Type dataType;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(2).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE}).validateInputSeriesDataType(1, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        this.dataType = parameters.getDataType(0);
        configurations.setAccessStrategy((AccessStrategy)new MappableRowByRowAccessStrategy()).setOutputDataType(this.dataType);
    }

    public Object transform(Row row) throws Exception {
        switch (this.dataType) {
            case INT32: {
                return row.getInt(0) + row.getInt(1);
            }
            case INT64: {
                return row.getLong(0) + row.getLong(1);
            }
            case FLOAT: {
                return Float.valueOf(row.getFloat(0) + row.getFloat(1));
            }
            case DOUBLE: {
                return row.getDouble(0) + row.getDouble(1);
            }
        }
        throw new Exception();
    }
}

