/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.iotdb.isession.ITableSession;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.TableSessionBuilder;
import org.apache.iotdb.session.subscription.ISubscriptionTableSession;
import org.apache.iotdb.session.subscription.SubscriptionTableSessionBuilder;
import org.apache.iotdb.session.subscription.consumer.ISubscriptionTablePullConsumer;
import org.apache.iotdb.session.subscription.consumer.table.SubscriptionTablePullConsumerBuilder;
import org.apache.iotdb.session.subscription.payload.SubscriptionMessage;
import org.apache.iotdb.session.subscription.payload.SubscriptionSessionDataSet;

public class TableModelSubscriptionSessionExample {
    private static final String HOST = "127.0.0.1";
    private static final int PORT = 6667;
    private static final String TOPIC_1 = "topic1";
    private static final String TOPIC_2 = "`'topic2'`";
    private static final String TOPIC_3 = "`\"topic3\"`";
    private static final String TOPIC_4 = "`\"top \\.i.c4\"`";
    private static final long SLEEP_NS = 1000000000L;
    private static final long POLL_TIMEOUT_MS = 10000L;
    private static final int MAX_RETRY_TIMES = 3;
    private static final int PARALLELISM = 8;
    private static final long CURRENT_TIME = System.currentTimeMillis();

    private static void createDataBaseAndTable(ITableSession session, String database, String table) throws IoTDBConnectionException, StatementExecutionException {
        session.executeNonQueryStatement("create database if not exists " + database);
        session.executeNonQueryStatement("use " + database);
        session.executeNonQueryStatement(String.format("CREATE TABLE %s (s0 string tag, s1 string tag, s2 string tag, s3 string tag, s4 int64 field, s5 float field, s6 string field, s7 timestamp field, s8 int32 field, s9 double field, s10 date field, s11 text field)", table));
    }

    private static void insertData(ITableSession session, String dataBaseName, String tableName, int start, int end) throws IoTDBConnectionException, StatementExecutionException {
        ArrayList<String> list = new ArrayList<String>(end - start + 1);
        for (int i = start; i < end; ++i) {
            list.add(String.format("insert into %s (s0, s3, s2, s1, s4, s5, s6, s7, s8, s9, s10, s11, time) values ('t%s','t%s','t%s','t%s','%s', %s.0, %s, %s, %d, %d.0, '%s', '%s', %s)", tableName, i, i, i, i, i, i, i, i, i, i, TableModelSubscriptionSessionExample.getDateStr(i), i, i));
        }
        list.add("flush");
        session.executeNonQueryStatement("use " + dataBaseName);
        for (String s : list) {
            session.executeNonQueryStatement(s);
        }
    }

    private static String getDateStr(int value) {
        Date date = new Date(value);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return dateFormat.format(date);
        }
        catch (Exception e) {
            return "1970-01-01";
        }
    }

    private static void dataSubscription() throws Exception {
        try (ISubscriptionTableSession session = new SubscriptionTableSessionBuilder().host(HOST).port(6667).username("root").password("root").build();){
            Properties config = new Properties();
            config.put("database", "db");
            config.put("table", "test");
            config.put("start-time", (Object)25);
            config.put("end-time", (Object)75);
            config.put("strict", "true");
            session.createTopic(TOPIC_1, config);
        }
        int retryCount = 0;
        try (ISubscriptionTablePullConsumer consumer1 = new SubscriptionTablePullConsumerBuilder().consumerId("c1").consumerGroupId("cg1").buildTablePullConsumer();){
            List messages;
            consumer1.open();
            consumer1.subscribe(TOPIC_1);
            while (!(messages = consumer1.poll(10000L)).isEmpty() || ++retryCount < 3) {
                for (SubscriptionMessage message : messages) {
                    for (SubscriptionSessionDataSet dataSet : message.getSessionDataSetsHandler()) {
                        System.out.println(dataSet.getColumnNames());
                        System.out.println(dataSet.getColumnTypes());
                        while (dataSet.hasNext()) {
                            System.out.println(dataSet.next());
                        }
                    }
                }
            }
            try (ISubscriptionTableSession session = new SubscriptionTableSessionBuilder().host(HOST).port(6667).username("root").password("root").build();){
                session.getTopics().forEach(System.out::println);
                session.getSubscriptions().forEach(System.out::println);
            }
            consumer1.unsubscribe(TOPIC_1);
        }
    }

    public static void main(String[] args) throws Exception {
        try (ITableSession session = new TableSessionBuilder().nodeUrls(Collections.singletonList("127.0.0.1:6667")).username("root").password("root").build();){
            TableModelSubscriptionSessionExample.createDataBaseAndTable(session, "db", "test");
            TableModelSubscriptionSessionExample.insertData(session, "db", "test", 0, 100);
            TableModelSubscriptionSessionExample.dataSubscription();
        }
    }
}

