/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"left"}, parameter="(String str, Integer len)", descriptions={"- Return \"\" if any parameter is NULL;", "- Return \"\" if 'len' is less than or equal to zero;", "- Return a substring of len starting from the right side of the 'str'."}, examples={"left('hello world',100) = \"hello world\"", "left('hello world',-15) = \"\""})
public class LeftFunction
implements ValueParser {
    private final ValueParser stringParser;
    private final ValueParser lengthParser;

    public LeftFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.lengthParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObj = this.stringParser.parse(sourceData, rowIndex, context);
        Object lengthObj = this.lengthParser.parse(sourceData, rowIndex, context);
        if (stringObj == null || lengthObj == null) {
            return null;
        }
        String str = OperatorTools.parseString(stringObj);
        int len = Integer.parseInt(OperatorTools.parseString(lengthObj));
        if (len <= 0) {
            return "";
        }
        return str.substring(0, Math.min(str.length(), len));
    }
}

