/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="json", names={"json_array_append"}, parameter="(String json_doc, String path1, String val1[,String path2, String val2, ...])", descriptions={"- Return \"\" if any argument is NULL;", "- Return the result of appends values to the end of the indicated arrays within a JSON document."}, examples={"json_array_append([\"a\", [\"b\", \"c\"], \"d\"],$[0],2,$[1],3) = [[\"a\",\"2\"],[\"b\",\"c\",\"3\"],\"d\"]"})
public class JsonArrayAppendFunction
implements ValueParser {
    private ValueParser jsonDocParser;
    private List<ValueParser> pathValuePairsParser;

    public JsonArrayAppendFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.jsonDocParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.pathValuePairsParser = new ArrayList<ValueParser>();
        for (int i = 1; i < expressions.size(); ++i) {
            this.pathValuePairsParser.add(OperatorTools.buildParser((Expression)expressions.get(i)));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object jsonDocObj = this.jsonDocParser.parse(sourceData, rowIndex, context);
        if (jsonDocObj == null) {
            return null;
        }
        ArrayList<Object> pathValuePairs = new ArrayList<Object>();
        for (ValueParser valueParser : this.pathValuePairsParser) {
            pathValuePairs.add(valueParser.parse(sourceData, rowIndex, context));
        }
        return JsonArrayAppendFunction.jsonArrayAppend(jsonDocObj.toString(), pathValuePairs);
    }

    public static String jsonArrayAppend(String jsonDoc, ArrayList<Object> pathValuePairs) {
        Object jsonObject;
        if (jsonDoc == null || pathValuePairs == null || pathValuePairs.size() % 2 != 0) {
            return null;
        }
        try {
            jsonObject = JSON.parse((String)jsonDoc);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid JSON document", e);
        }
        for (int i = 0; i < pathValuePairs.size(); i += 2) {
            String path = (String)pathValuePairs.get(i);
            Object value = pathValuePairs.get(i + 1);
            try {
                jsonObject = JsonArrayAppendFunction.appendValueToArray(jsonObject, path, JSON.parse((String)value.toString()));
                continue;
            }
            catch (Exception e) {
                jsonObject = JsonArrayAppendFunction.appendValueToArray(jsonObject, path, value);
            }
        }
        return JSON.toJSONString((Object)jsonObject);
    }

    private static Object appendValueToArray(Object jsonObject, String path, Object value) {
        Object targetNode = JSONPath.eval((Object)jsonObject, (String)path);
        if (targetNode == null) {
            throw new IllegalArgumentException("Target path does not exist.");
        }
        if (targetNode instanceof JSONArray) {
            JSONArray array = (JSONArray)targetNode;
            array.add(value);
        } else {
            JSONArray newArray = new JSONArray();
            newArray.add(targetNode);
            newArray.add(value);
            if ("$".equals(path)) {
                return newArray;
            }
            JSONPath.set((Object)jsonObject, (String)path, (Object)newArray);
        }
        return jsonObject;
    }
}

