/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"array"}, parameter="(String value1 [,String value2, ....])", descriptions={"- Return an array created from a list of values ('value1', 'value2', ....)."}, examples={"array('he',7,'xxd') = [he, 7, xxd]", "array(array('he',5),'xxd') = return [[he, 5], xxd]", "array(array('he',5),array('','')) = return [[he, 5], [, ]]"})
public class ArrayFunction
implements ValueParser {
    private List<ValueParser> parserList;

    public ArrayFunction(Function expr) {
        if (expr.getParameters() == null) {
            this.parserList = new ArrayList<ValueParser>();
        } else {
            List params = expr.getParameters().getExpressions();
            this.parserList = new ArrayList<ValueParser>(params.size());
            for (Expression param : params) {
                ValueParser node = OperatorTools.buildParser(param);
                this.parserList.add(node);
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (ValueParser valueParser : this.parserList) {
            Object parseObj = valueParser.parse(sourceData, rowIndex, context);
            res.add(parseObj);
        }
        return res;
    }
}

