/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"chr"}, parameter="(Integer integer)", descriptions={"- Return NULL if 'integer' is NULL;", "- Return the ASCII character having the binary equivalent to 'integer'."}, examples={"chr(97) = \"a\"", "chr(353) = \"a\""})
public class ChrFunction
implements ValueParser {
    private ValueParser numberParser;
    private final int chrSum = 256;

    public ChrFunction(Function expr) {
        this.numberParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.numberParser == null) {
            return null;
        }
        Object numberObj = this.numberParser.parse(sourceData, rowIndex, context);
        if (numberObj == null) {
            return null;
        }
        BigDecimal numberValue = OperatorTools.parseBigDecimal(numberObj);
        BigDecimal temp = numberValue.remainder(new BigDecimal(256));
        BigDecimal res = temp.compareTo(BigDecimal.ZERO) >= 0 ? temp : temp.add(new BigDecimal(256));
        return String.valueOf((char)res.intValue());
    }
}

