/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"url_decode"}, parameter="(String str)", descriptions={"- Return \"\" if 'str' is NULL, or there is an issue with the decoding process(such as encountering an illegal escape pattern), or the encoding scheme is not supported;", "- Return the result of decoding a given 'str' in 'application/x-www-form-urlencoded' format using the UTF-8 encoding scheme."}, examples={"url_decode('https%3A%2F%2Fapache.inlong.com%2Fsearch%3Fq%3Djava+url+encode') = \"https://apache.inlong.com/search?q=java url encode\""})
public class UrlDecodeFunction
implements ValueParser {
    private final ValueParser stringParser;

    public UrlDecodeFunction(Function expr) {
        this.stringParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObj = this.stringParser.parse(sourceData, rowIndex, context);
        if (stringObj == null) {
            return null;
        }
        String string = OperatorTools.parseString(stringObj);
        if (string == null) {
            return null;
        }
        try {
            return URLDecoder.decode(string, StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            return null;
        }
    }
}

