/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"format"}, parameter="(Numeric X,Integer D)", descriptions={"- Return \"\" if 'X' or 'D' is NULL;", "- Return the result of formatting the number 'X' to \"#,###,###.##\" format, rounded to 'D' decimal places."}, examples={"FORMAT(12332.123456, 4) = \"12,332.1235\"", "FORMAT(12332.2,0) = \"12,332\""})
public class FormatFunction
implements ValueParser {
    private ValueParser numberParser;
    private ValueParser reservedDigitsParser;

    public FormatFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.numberParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.reservedDigitsParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object numberObj = this.numberParser.parse(sourceData, rowIndex, context);
        Object reservedDigitsObj = this.reservedDigitsParser.parse(sourceData, rowIndex, context);
        if (numberObj == null || reservedDigitsObj == null) {
            return null;
        }
        BigDecimal number = OperatorTools.parseBigDecimal(numberObj);
        int reservedDigits = OperatorTools.parseBigDecimal(reservedDigitsObj).intValue();
        if (reservedDigits < 0) {
            reservedDigits = 0;
        }
        StringBuilder pattern = new StringBuilder("#,###");
        if (reservedDigits > 0) {
            pattern.append(".");
            for (int i = 0; i < reservedDigits; ++i) {
                pattern.append("0");
            }
        }
        number = number.setScale(reservedDigits, RoundingMode.HALF_UP);
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        df.applyPattern(pattern.toString());
        return df.format(number);
    }
}

