/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="string", names={"contains"}, parameter="(String leftStr , String rightStr)", descriptions={"- Return \"\" if 'leftStr' or rightStr is NULL;", "- Return True if 'rightStr' is found inside 'leftStr';", "- Return False otherwise."}, examples={"contains('Transform SQL', 'SQL') = true"})
public class ContainsFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(ContainsFunction.class);
    private ValueParser leftStrParser;
    private ValueParser rightStrParser;

    public ContainsFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.leftStrParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.rightStrParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object leftStrObj = this.leftStrParser.parse(sourceData, rowIndex, context);
        Object rightStrObj = this.rightStrParser.parse(sourceData, rowIndex, context);
        if (leftStrObj == null || rightStrObj == null) {
            return null;
        }
        String leftStr = OperatorTools.parseString(leftStrObj);
        String rightStr = OperatorTools.parseString(rightStrObj);
        return leftStr == null || rightStr == null ? null : Boolean.valueOf(leftStr.contains(rightStr));
    }
}

