/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="string", names={"concat"}, parameter="(String string1 [, String string2, ...])", descriptions={"- Return NULL If any parameter is NULL;", "- Return the string of the connection ('string1', 'string2',...)."}, examples={"CONCAT(\"AA\", \"BB\", \"CC\") = \"AABBCC\""})
public class ConcatFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(ConcatFunction.class);
    private List<ValueParser> nodeList;

    public ConcatFunction(Function expr) {
        if (expr.getParameters() == null) {
            this.nodeList = new ArrayList<ValueParser>();
        } else {
            List params = expr.getParameters().getExpressions();
            this.nodeList = new ArrayList<ValueParser>(params.size());
            for (Expression param : params) {
                ValueParser node = OperatorTools.buildParser(param);
                this.nodeList.add(node);
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        StringBuilder builder = new StringBuilder();
        for (ValueParser node : this.nodeList) {
            builder.append(node.parse(sourceData, rowIndex, context));
        }
        return builder.toString();
    }
}

