/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"bin"}, parameter="(Integer integer)", descriptions={"- Return \"\" if 'integer' is NULL;", "- Return a string representation of 'integer' in binary format."}, examples={"bin(4) = 100"})
public class BinFunction
implements ValueParser {
    private ValueParser valueParser;

    public BinFunction(Function expr) {
        List expressions;
        if (expr.getParameters() != null && (expressions = expr.getParameters().getExpressions()) != null && expressions.size() == 1) {
            this.valueParser = OperatorTools.buildParser((Expression)expressions.get(0));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.valueParser != null) {
            Object valueObj = this.valueParser.parse(sourceData, rowIndex, context);
            if (valueObj == null) {
                return null;
            }
            BigDecimal value = OperatorTools.parseBigDecimal(valueObj);
            return Integer.toBinaryString(value.intValue());
        }
        return null;
    }
}

