/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Context {
    private final Map<String, Object> configuration;
    private final Map<String, Object> extParams;
    private final Map<String, Object> runtimeParams;

    public Context(Map<String, Object> configuration, Map<String, Object> extParams) {
        this.configuration = configuration;
        this.extParams = extParams;
        this.runtimeParams = new ConcurrentHashMap<String, Object>();
    }

    public Object put(String key, Object value) {
        return this.runtimeParams.put(key, value);
    }

    public Object get(String key) {
        Object obj = this.runtimeParams.get(key);
        if (obj != null) {
            return obj;
        }
        obj = this.extParams.get(key);
        if (obj != null) {
            return obj;
        }
        return this.configuration.get(key);
    }

    public String getStringOrDefault(String key, String defaultValue) {
        String str = this.getString(key);
        if (str == null) {
            return defaultValue;
        }
        return str;
    }

    public String getString(String key) {
        Object obj = this.get(key);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public Integer getInteger(String key) {
        Object obj = this.get(key);
        if (obj != null) {
            return Integer.getInteger(obj.toString());
        }
        return null;
    }

    public Long getLong(String key) {
        Object obj = this.get(key);
        if (obj != null) {
            return Long.getLong(obj.toString());
        }
        return null;
    }
}

