/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.encode;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.inlong.sdk.transform.encode.ParquetByteArrayWriter;
import org.apache.inlong.sdk.transform.encode.ParquetWriteRunner;
import org.apache.inlong.sdk.transform.encode.SinkData;
import org.apache.inlong.sdk.transform.encode.SinkEncoder;
import org.apache.inlong.sdk.transform.pojo.FieldInfo;
import org.apache.inlong.sdk.transform.pojo.ParquetSinkInfo;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;

public class ParquetSinkEncoder
extends SinkEncoder<ByteArrayOutputStream> {
    protected ParquetSinkInfo sinkInfo;
    private ParquetByteArrayWriter<Object[]> writer;

    public ParquetSinkEncoder(ParquetSinkInfo sinkInfo) {
        super(sinkInfo.getFields());
        this.sinkInfo = sinkInfo;
        ArrayList<Object> typesList = new ArrayList<Object>();
        for (FieldInfo fieldInfo : this.fields) {
            typesList.add(((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(fieldInfo.getName()));
        }
        MessageType schema = new MessageType("Output", typesList);
        ParquetWriteRunner<Object[]> writeRunner = (record, valueWriter) -> {
            for (int i = 0; i < ((Object[])record).length; ++i) {
                valueWriter.write(((FieldInfo)this.fields.get(i)).getName(), record[i]);
            }
        };
        try {
            this.writer = ParquetByteArrayWriter.buildWriter(schema, writeRunner);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ByteArrayOutputStream encode(SinkData sinkData, Context context) {
        int size = this.fields.size();
        Object[] rowsInfo = new Object[size];
        Arrays.fill(rowsInfo, "");
        for (int i = 0; i < size; ++i) {
            String fieldData = sinkData.getField(((FieldInfo)this.fields.get(i)).getName());
            if (fieldData == null) continue;
            rowsInfo[i] = fieldData;
        }
        try {
            this.writer.write(rowsInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.writer.getByteArrayOutputStream();
    }

    public byte[] mergeByteArray(List<ByteArrayOutputStream> list) {
        if (list.isEmpty()) {
            return null;
        }
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list.get(0).toByteArray();
    }
}

