/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.data.RowData;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.sdk.transform.decode.RowDataSourceData;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.decode.SourceDecoder;
import org.apache.inlong.sdk.transform.pojo.FieldInfo;
import org.apache.inlong.sdk.transform.pojo.RowDataSourceInfo;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.utils.RowToFieldDataUtils;
import org.apache.inlong.sort.formats.base.TableFormatForRowDataUtils;

public class RowDataSourceDecoder
extends SourceDecoder<RowData> {
    private final Map<String, Integer> fieldPositionMap;
    private final RowToFieldDataUtils.RowFieldConverter[] rowFieldConverters;

    public RowDataSourceDecoder(RowDataSourceInfo sourceInfo) {
        super(sourceInfo.getFields());
        List<FieldInfo> fields = sourceInfo.getFields();
        this.fieldPositionMap = this.parseFieldPositionMap(fields);
        this.rowFieldConverters = new RowToFieldDataUtils.RowFieldConverter[fields.size()];
        for (int i = 0; i < this.rowFieldConverters.length; ++i) {
            this.rowFieldConverters[i] = RowToFieldDataUtils.createNullableRowFieldConverter(TableFormatForRowDataUtils.deriveLogicalType((FormatInfo)fields.get(i).getFormatInfo()));
        }
    }

    private Map<String, Integer> parseFieldPositionMap(List<FieldInfo> fields) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < fields.size(); ++i) {
            map.put(fields.get(i).getName(), i);
        }
        return map;
    }

    @Override
    public SourceData decode(byte[] srcBytes, Context context) {
        throw new UnsupportedOperationException("do not support decoding bytes for row data decoder");
    }

    @Override
    public SourceData decode(RowData rowData, Context context) {
        return new RowDataSourceData(rowData, this.fieldPositionMap, this.rowFieldConverters);
    }
}

