/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import java.util.Map;
import org.apache.flink.table.data.RowData;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.utils.RowToFieldDataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowDataSourceData
implements SourceData {
    private static final Logger log = LoggerFactory.getLogger(RowDataSourceData.class);
    private final RowData rowData;
    private final Map<String, Integer> fieldPositionMap;
    private final RowToFieldDataUtils.RowFieldConverter[] converters;

    public RowDataSourceData(RowData rowData, Map<String, Integer> fieldPositionMap, RowToFieldDataUtils.RowFieldConverter[] converters) {
        this.rowData = rowData;
        this.fieldPositionMap = fieldPositionMap;
        this.converters = converters;
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public Object getField(int rowNum, String fieldName) {
        if (rowNum != 0) {
            return null;
        }
        try {
            int fieldPosition = this.fieldPositionMap.get(fieldName);
            return this.converters[fieldPosition].convert(this.rowData, fieldPosition);
        }
        catch (Throwable e) {
            log.error("failed to convert field={}", (Object)fieldName, (Object)e);
            return null;
        }
    }
}

