/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.transform.decode.JsonNode;
import org.apache.inlong.sdk.transform.decode.JsonSourceData;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.decode.SourceDecoder;
import org.apache.inlong.sdk.transform.pojo.JsonSourceInfo;
import org.apache.inlong.sdk.transform.process.Context;

public class JsonSourceDecoder
extends SourceDecoder<String> {
    protected JsonSourceInfo sourceInfo;
    private Charset srcCharset = Charset.defaultCharset();
    private String rowsNodePath;
    private List<JsonNode> childNodes;
    private Gson gson = new Gson();

    public JsonSourceDecoder(JsonSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        if (!StringUtils.isBlank((CharSequence)sourceInfo.getCharset())) {
            this.srcCharset = Charset.forName(sourceInfo.getCharset());
        }
        this.rowsNodePath = sourceInfo.getRowsNodePath();
        if (!StringUtils.isBlank((CharSequence)this.rowsNodePath)) {
            String[] nodeStrings;
            this.childNodes = new ArrayList<JsonNode>();
            for (String nodeString : nodeStrings = this.rowsNodePath.split("\\.")) {
                this.childNodes.add(new JsonNode(nodeString));
            }
        }
    }

    @Override
    public SourceData decode(byte[] srcBytes, Context context) {
        String srcString = new String(srcBytes, this.srcCharset);
        return this.decode(srcString, context);
    }

    @Override
    public SourceData decode(String srcString, Context context) {
        JsonObject root = (JsonObject)this.gson.fromJson(srcString, JsonObject.class);
        JsonArray childRoot = null;
        if (CollectionUtils.isEmpty(this.childNodes)) {
            return new JsonSourceData(root, null);
        }
        JsonObject current = root;
        for (JsonNode node : this.childNodes) {
            if (!current.isJsonObject()) {
                return new JsonSourceData(root, null);
            }
            JsonElement newElement = current.getAsJsonObject().get(node.getName());
            if (newElement == null) {
                return new JsonSourceData(root, null);
            }
            if (!node.isArray()) {
                current = newElement;
                continue;
            }
            current = this.getElementFromArray(node, newElement);
            if (current != null) continue;
            return new JsonSourceData(root, null);
        }
        if (!current.isJsonArray()) {
            return new JsonSourceData(root, null);
        }
        childRoot = current.getAsJsonArray();
        return new JsonSourceData(root, childRoot);
    }

    private JsonElement getElementFromArray(JsonNode node, JsonElement curElement) {
        if (node.getArrayIndices().isEmpty()) {
            return null;
        }
        for (int index : node.getArrayIndices()) {
            if (!curElement.isJsonArray()) {
                return null;
            }
            JsonArray newArray = curElement.getAsJsonArray();
            if (index >= newArray.size()) {
                return null;
            }
            curElement = newArray.get(index);
        }
        return curElement;
    }
}

