/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source.iceberg;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.dao.entity.InlongStreamFieldEntity;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.pojo.node.iceberg.IcebergDataNodeInfo;
import org.apache.inlong.manager.pojo.sink.iceberg.IcebergColumnInfo;
import org.apache.inlong.manager.pojo.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.iceberg.IcebergSource;
import org.apache.inlong.manager.pojo.source.iceberg.IcebergSourceDTO;
import org.apache.inlong.manager.pojo.source.iceberg.IcebergSourceRequest;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.service.resource.sink.iceberg.IcebergCatalogUtils;
import org.apache.inlong.manager.service.source.AbstractSourceOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IcebergSourceOperator
extends AbstractSourceOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergSourceOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String sourceType) {
        return "ICEBERG".equals(sourceType);
    }

    @Override
    protected String getSourceType() {
        return "ICEBERG";
    }

    @Override
    public String getExtParams(StreamSourceEntity sourceEntity) {
        IcebergSourceDTO icebergSourceDTO = (IcebergSourceDTO)JsonUtils.parseObject((String)sourceEntity.getExtParams(), IcebergSourceDTO.class);
        if (Objects.nonNull(icebergSourceDTO) && StringUtils.isBlank((CharSequence)icebergSourceDTO.getUri())) {
            IcebergDataNodeInfo dataNodeInfo = (IcebergDataNodeInfo)this.dataNodeService.get(sourceEntity.getDataNodeName(), "ICEBERG");
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)icebergSourceDTO, (boolean)true);
            icebergSourceDTO.setUri(dataNodeInfo.getUrl());
            return JsonUtils.toJsonString((Object)icebergSourceDTO);
        }
        return sourceEntity.getExtParams();
    }

    @Override
    protected void setTargetEntity(SourceRequest request, StreamSourceEntity targetEntity) {
        IcebergSourceRequest sourceRequest = (IcebergSourceRequest)request;
        CommonBeanUtils.copyProperties((Object)sourceRequest, (Object)targetEntity, (boolean)true);
        try {
            IcebergSourceDTO dto = IcebergSourceDTO.getFromRequest((IcebergSourceRequest)sourceRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("serialize extParams of Kafka SourceDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    public StreamSource getFromEntity(StreamSourceEntity entity) {
        IcebergSource source = new IcebergSource();
        if (entity == null) {
            return source;
        }
        IcebergSourceDTO dto = IcebergSourceDTO.getFromJson((String)entity.getExtParams());
        if (StringUtils.isBlank((CharSequence)dto.getUri())) {
            if (StringUtils.isBlank((CharSequence)entity.getDataNodeName())) {
                throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, "iceberg catalog uri unspecified and data node is blank");
            }
            IcebergDataNodeInfo dataNodeInfo = (IcebergDataNodeInfo)this.dataNodeService.get(entity.getDataNodeName(), "ICEBERG");
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)dto, (boolean)true);
            dto.setUri(dataNodeInfo.getUrl());
        }
        CommonBeanUtils.copyProperties((Object)entity, (Object)source, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)source, (boolean)true);
        List<StreamField> sourceFields = super.getSourceFields(entity.getId());
        source.setFieldList(sourceFields);
        return source;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void syncSourceFieldInfo(SourceRequest request, String operator) {
        IcebergSourceRequest sourceRequest = (IcebergSourceRequest)request;
        LOGGER.info("sync source field for iceberg {}", (Object)sourceRequest);
        String metastoreUri = sourceRequest.getUri();
        String dbName = sourceRequest.getDatabase();
        String tableName = sourceRequest.getTableName();
        boolean tableExists = IcebergCatalogUtils.tableExists(metastoreUri, dbName, tableName);
        ArrayList<StreamField> streamFields = new ArrayList<StreamField>();
        if (tableExists) {
            List<IcebergColumnInfo> existColumns = IcebergCatalogUtils.getColumns(metastoreUri, dbName, tableName);
            for (IcebergColumnInfo columnInfo : existColumns) {
                StreamField streamField = new StreamField();
                streamField.setFieldName(columnInfo.getFieldName());
                streamField.setFieldType(FieldInfoUtils.sqlTypeToJavaTypeStr((String)columnInfo.getFieldType()));
                streamField.setFieldComment(columnInfo.getFieldComment());
                streamFields.add(streamField);
            }
            this.updateField(sourceRequest.getInlongGroupId(), sourceRequest.getInlongStreamId(), streamFields);
        }
    }

    public void updateField(String groupId, String streamId, List<StreamField> fieldList) {
        LOGGER.debug("begin to update inlong stream field, groupId={}, streamId={}, field={}", new Object[]{groupId, streamId, fieldList});
        try {
            this.streamFieldMapper.deleteAllByIdentifier(groupId, streamId);
            if (CollectionUtils.isEmpty(fieldList)) {
                return;
            }
            fieldList.forEach(streamField -> streamField.setId(null));
            List list = CommonBeanUtils.copyListProperties(fieldList, InlongStreamFieldEntity::new);
            for (InlongStreamFieldEntity entity : list) {
                entity.setInlongGroupId(groupId);
                entity.setInlongStreamId(streamId);
                entity.setIsDeleted(InlongConstants.UN_DELETED);
            }
            this.streamFieldMapper.insertAll(list);
            LOGGER.info("success to update inlong stream field for groupId={}", (Object)groupId);
        }
        catch (Exception e) {
            LOGGER.error("failed to update inlong stream field: ", (Throwable)e);
            throw new BusinessException(ErrorCodeEnum.STREAM_FIELD_SAVE_FAILED);
        }
    }
}

