/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.mysql;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.mysql.MySQLDataNodeDTO;
import org.apache.inlong.manager.pojo.sink.SinkInfo;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLColumnInfo;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLSinkDTO;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLTableInfo;
import org.apache.inlong.manager.service.node.DataNodeOperateHelper;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.sink.mysql.MySQLJdbcUtils;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MySQLResourceOperator
implements SinkResourceOperator {
    private static final Logger LOG = LoggerFactory.getLogger(MySQLResourceOperator.class);
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamSinkFieldEntityMapper fieldEntityMapper;
    @Autowired
    private DataNodeOperateHelper dataNodeHelper;

    @Override
    public Boolean accept(String sinkType) {
        return "MYSQL".equals(sinkType);
    }

    @Override
    public void createSinkResource(SinkInfo sinkInfo) {
        LOG.info("begin to create MySQL resources sinkId={}", (Object)sinkInfo.getId());
        if (SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(sinkInfo.getStatus())) {
            LOG.warn("MySQL resource [" + sinkInfo.getId() + "] already success, skip to create");
            return;
        }
        if (InlongConstants.DISABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())) {
            LOG.warn("create resource was disabled, skip to create for [" + sinkInfo.getId() + "]");
            return;
        }
        this.createTable(sinkInfo);
    }

    private void createTable(SinkInfo sinkInfo) {
        LOG.info("begin to create MySQL table for sinkId={}", (Object)sinkInfo.getId());
        List fieldList = this.fieldEntityMapper.selectBySinkId(sinkInfo.getId());
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            LOG.warn("no MySQL fields found, skip to create table for sinkId={}", (Object)sinkInfo.getId());
        }
        ArrayList<MySQLColumnInfo> columnList = new ArrayList<MySQLColumnInfo>();
        for (StreamSinkFieldEntity field : fieldList) {
            MySQLColumnInfo columnInfo = new MySQLColumnInfo(field.getFieldName(), field.getFieldType(), field.getFieldComment());
            columnList.add(columnInfo);
        }
        MySQLSinkDTO sinkDTO = this.getMysqlInfo(sinkInfo);
        MySQLTableInfo tableInfo = MySQLSinkDTO.getTableInfo((MySQLSinkDTO)sinkDTO, columnList);
        try (Connection conn = MySQLJdbcUtils.getConnection(sinkDTO.getJdbcUrl(), sinkDTO.getUsername(), sinkDTO.getPassword());){
            MySQLJdbcUtils.createDb(conn, tableInfo.getDbName());
            MySQLJdbcUtils.createTable(conn, tableInfo);
            MySQLJdbcUtils.addColumns(conn, tableInfo.getDbName(), tableInfo.getTableName(), columnList);
            String info = "success to create MySQL resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), info);
            LOG.info(info + " for sinkInfo={}", (Object)sinkInfo);
        }
        catch (Throwable e) {
            String errMsg = "create MySQL table failed: " + e.getMessage();
            LOG.error(errMsg, e);
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_FAILED.getCode(), errMsg);
            throw new WorkflowException(errMsg);
        }
        LOG.info("success create MySQL table for data sink [" + sinkInfo.getId() + "]");
    }

    private MySQLSinkDTO getMysqlInfo(SinkInfo sinkInfo) {
        MySQLSinkDTO mysqlInfo = MySQLSinkDTO.getFromJson((String)sinkInfo.getExtParams());
        if (StringUtils.isBlank((CharSequence)mysqlInfo.getJdbcUrl())) {
            String dataNodeName = sinkInfo.getDataNodeName();
            Preconditions.expectNotBlank((String)dataNodeName, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"mysql jdbc url not specified and data node is empty");
            DataNodeInfo dataNodeInfo = this.dataNodeHelper.getDataNodeInfo(dataNodeName, sinkInfo.getSinkType());
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)mysqlInfo);
            mysqlInfo.setJdbcUrl(MySQLDataNodeDTO.convertToJdbcurl((String)dataNodeInfo.getUrl()));
            mysqlInfo.setPassword(dataNodeInfo.getToken());
        }
        return mysqlInfo;
    }
}

