/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.redis;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.exceptions.IllegalArgumentIOException;
import org.apache.inlong.manager.pojo.node.redis.RedisDataNodeRequest;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisSentinelPool;

public class RedisResourceClient {
    private static final String REDIS_TEST_KEY = "__inLong_test_key__";
    private static final String REDIS_TEST_VALUE = "__inLong_test_value__";
    private static final String HOST_PORT_SEPARATOR = ":";
    private static final String NODE_LINE_SEPARATOR = ",|;";

    public static boolean testConnection(RedisDataNodeRequest request) throws IOException {
        String clusterMode;
        switch (clusterMode = request.getClusterMode()) {
            case "standalone": {
                return RedisStandaloneTester.builder().host(request.getHost()).port(request.getPort()).build().testConnection();
            }
            case "cluster": {
                return RedisClusterTester.builder().nodes(request.getClusterNodes()).build().testConnection();
            }
            case "sentinel": {
                return RedisSentinelTester.builder().masterName(request.getMasterName()).sentinelsInfo(request.getSentinelsInfo()).build().testConnection();
            }
        }
        throw new IllegalArgumentIOException("Unknown cluster mode: " + clusterMode);
    }

    static class RedisStandaloneTester
    implements RedisTester {
        private String host;
        private int port;

        @Override
        public boolean testConnection() throws IOException {
            String result;
            try (Jedis jedis = new Jedis(this.host, this.port);){
                jedis.set(RedisResourceClient.REDIS_TEST_KEY, RedisResourceClient.REDIS_TEST_VALUE);
                result = jedis.get(RedisResourceClient.REDIS_TEST_KEY);
            }
            return RedisResourceClient.REDIS_TEST_VALUE.equals(result);
        }

        RedisStandaloneTester(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public static RedisStandaloneTesterBuilder builder() {
            return new RedisStandaloneTesterBuilder();
        }

        public static class RedisStandaloneTesterBuilder {
            private String host;
            private int port;

            RedisStandaloneTesterBuilder() {
            }

            public RedisStandaloneTesterBuilder host(String host) {
                this.host = host;
                return this;
            }

            public RedisStandaloneTesterBuilder port(int port) {
                this.port = port;
                return this;
            }

            public RedisStandaloneTester build() {
                return new RedisStandaloneTester(this.host, this.port);
            }

            public String toString() {
                return "RedisResourceClient.RedisStandaloneTester.RedisStandaloneTesterBuilder(host=" + this.host + ", port=" + this.port + ")";
            }
        }
    }

    static class RedisSentinelTester
    implements RedisTester {
        private String masterName;
        private String sentinelsInfo;

        @Override
        public boolean testConnection() throws IOException {
            String result;
            HashSet<String> sentinels = new HashSet<String>(Arrays.asList(this.sentinelsInfo.split(RedisResourceClient.NODE_LINE_SEPARATOR)));
            try (JedisSentinelPool pool = new JedisSentinelPool(this.masterName, sentinels);){
                Jedis jedis = pool.getResource();
                jedis.set(RedisResourceClient.REDIS_TEST_KEY, RedisResourceClient.REDIS_TEST_VALUE);
                result = jedis.get(RedisResourceClient.REDIS_TEST_KEY);
            }
            return RedisResourceClient.REDIS_TEST_VALUE.equals(result);
        }

        RedisSentinelTester(String masterName, String sentinelsInfo) {
            this.masterName = masterName;
            this.sentinelsInfo = sentinelsInfo;
        }

        public static RedisSentinelTesterBuilder builder() {
            return new RedisSentinelTesterBuilder();
        }

        public static class RedisSentinelTesterBuilder {
            private String masterName;
            private String sentinelsInfo;

            RedisSentinelTesterBuilder() {
            }

            public RedisSentinelTesterBuilder masterName(String masterName) {
                this.masterName = masterName;
                return this;
            }

            public RedisSentinelTesterBuilder sentinelsInfo(String sentinelsInfo) {
                this.sentinelsInfo = sentinelsInfo;
                return this;
            }

            public RedisSentinelTester build() {
                return new RedisSentinelTester(this.masterName, this.sentinelsInfo);
            }

            public String toString() {
                return "RedisResourceClient.RedisSentinelTester.RedisSentinelTesterBuilder(masterName=" + this.masterName + ", sentinelsInfo=" + this.sentinelsInfo + ")";
            }
        }
    }

    static class RedisClusterTester
    implements RedisTester {
        private String nodes;

        @Override
        public boolean testConnection() throws IOException {
            String result;
            Set hostPorts = Arrays.stream(this.nodes.split(RedisResourceClient.NODE_LINE_SEPARATOR)).map(s -> {
                String[] split = s.split(RedisResourceClient.HOST_PORT_SEPARATOR);
                int port = Integer.parseInt(split[1]);
                return new HostAndPort(split[0], port);
            }).collect(Collectors.toSet());
            try (JedisCluster jedisCluster = new JedisCluster(hostPorts);){
                jedisCluster.set(RedisResourceClient.REDIS_TEST_KEY, RedisResourceClient.REDIS_TEST_VALUE);
                result = jedisCluster.get(RedisResourceClient.REDIS_TEST_KEY);
            }
            return RedisResourceClient.REDIS_TEST_VALUE.equals(result);
        }

        RedisClusterTester(String nodes) {
            this.nodes = nodes;
        }

        public static RedisClusterTesterBuilder builder() {
            return new RedisClusterTesterBuilder();
        }

        public static class RedisClusterTesterBuilder {
            private String nodes;

            RedisClusterTesterBuilder() {
            }

            public RedisClusterTesterBuilder nodes(String nodes) {
                this.nodes = nodes;
                return this;
            }

            public RedisClusterTester build() {
                return new RedisClusterTester(this.nodes);
            }

            public String toString() {
                return "RedisResourceClient.RedisClusterTester.RedisClusterTesterBuilder(nodes=" + this.nodes + ")";
            }
        }
    }

    static interface RedisTester {
        public boolean testConnection() throws IOException;
    }
}

