/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.source;

import java.util.List;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.SourceStatus;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.StreamResourceProcessForm;
import org.apache.inlong.manager.service.source.SourceOperatorFactory;
import org.apache.inlong.manager.service.source.StreamSourceOperator;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SourceOperateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SourceStartListener
implements SourceOperateListener {
    private static final Logger log = LoggerFactory.getLogger(SourceStartListener.class);
    @Autowired
    protected StreamSourceService streamSourceService;
    @Autowired
    private SourceOperatorFactory operatorFactory;

    public String name() {
        return this.getClass().getSimpleName();
    }

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public boolean accept(WorkflowContext context) {
        if (this.isGroupProcessForm(context)) {
            return false;
        }
        StreamResourceProcessForm processForm = (StreamResourceProcessForm)context.getProcessForm();
        return InlongConstants.STANDARD_MODE.equals(processForm.getGroupInfo().getInlongGroupMode()) && processForm.getGroupOperateType() == GroupOperateType.INIT;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        StreamResourceProcessForm form = (StreamResourceProcessForm)context.getProcessForm();
        String operator = context.getOperator();
        InlongStreamInfo streamInfo = form.getStreamInfo();
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        if (InlongConstants.DATASYNC_REALTIME_MODE.equals(form.getGroupInfo().getInlongGroupMode()) || InlongConstants.DATASYNC_OFFLINE_MODE.equals(form.getGroupInfo().getInlongGroupMode())) {
            this.streamSourceService.updateStatus(groupId, streamId, SourceStatus.SOURCE_NORMAL.getCode(), operator);
        } else {
            this.streamSourceService.updateStatus(groupId, streamId, SourceStatus.TO_BE_ISSUED_ADD.getCode(), operator);
        }
        log.info("begin to update agent task config for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        List<StreamSource> sources = this.streamSourceService.listSource(groupId, streamId);
        for (StreamSource source : sources) {
            SourceRequest request = source.genSourceRequest();
            StreamSourceOperator sourceOperator = this.operatorFactory.getInstance(request.getSourceType());
            sourceOperator.updateAgentTaskConfig(request, operator);
        }
        log.info("success to update agent task config for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        return ListenerResult.success();
    }
}

