/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster.node;

import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongClusterNodeEntity;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeResponse;
import org.apache.inlong.manager.service.cluster.node.AbstractClusterNodeOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultClusterNodeOperator
extends AbstractClusterNodeOperator {
    private static final Logger log = LoggerFactory.getLogger(DefaultClusterNodeOperator.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClusterNodeOperator.class);
    public static final String DEFAULT = "DEFAULT";

    @Override
    public Boolean accept(String clusterNodeType) {
        return this.getClusterNodeType().equals(clusterNodeType);
    }

    @Override
    public String getClusterNodeType() {
        return DEFAULT;
    }

    @Override
    public ClusterNodeResponse getFromEntity(InlongClusterNodeEntity entity) {
        ClusterNodeResponse clusterNodeResponse = (ClusterNodeResponse)CommonBeanUtils.copyProperties((Object)entity, ClusterNodeResponse::new);
        LOGGER.debug("success to get inlong cluster node by id={}", (Object)entity.getId());
        return clusterNodeResponse;
    }

    @Override
    protected void setTargetEntity(ClusterNodeRequest request, InlongClusterNodeEntity targetEntity) {
        LOGGER.debug("do nothing for default cluster node in set target entity");
    }
}

