/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.oceanbase;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.node.oceanbase.OceanBaseDataNodeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="OceanBase data node info")
public class OceanBaseDataNodeDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(OceanBaseDataNodeDTO.class);
    private static final String OCEANBASE_JDBC_PREFIX = "jdbc:oceanbase://";
    @ApiModelProperty(value="URL of backup DB server")
    private String backupUrl;

    public static OceanBaseDataNodeDTO getFromRequest(OceanBaseDataNodeRequest request, String extParams) {
        OceanBaseDataNodeDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? OceanBaseDataNodeDTO.getFromJson(extParams) : new OceanBaseDataNodeDTO();
        return (OceanBaseDataNodeDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static OceanBaseDataNodeDTO getFromJson(@NotNull String extParams) {
        try {
            return (OceanBaseDataNodeDTO)JsonUtils.parseObject((String)extParams, OceanBaseDataNodeDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, String.format("Failed to parse extParams for OceanBase node: %s", e.getMessage()));
        }
    }

    public static String convertToJdbcurl(String url) {
        String jdbcUrl = url;
        if (StringUtils.isNotBlank((CharSequence)jdbcUrl) && !jdbcUrl.startsWith(OCEANBASE_JDBC_PREFIX)) {
            jdbcUrl = OCEANBASE_JDBC_PREFIX + jdbcUrl;
        }
        return jdbcUrl;
    }

    public static OceanBaseDataNodeDTOBuilder builder() {
        return new OceanBaseDataNodeDTOBuilder();
    }

    public String getBackupUrl() {
        return this.backupUrl;
    }

    public void setBackupUrl(String backupUrl) {
        this.backupUrl = backupUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OceanBaseDataNodeDTO)) {
            return false;
        }
        OceanBaseDataNodeDTO other = (OceanBaseDataNodeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$backupUrl = this.getBackupUrl();
        String other$backupUrl = other.getBackupUrl();
        return !(this$backupUrl == null ? other$backupUrl != null : !this$backupUrl.equals(other$backupUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OceanBaseDataNodeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $backupUrl = this.getBackupUrl();
        result = result * 59 + ($backupUrl == null ? 43 : $backupUrl.hashCode());
        return result;
    }

    public String toString() {
        return "OceanBaseDataNodeDTO(backupUrl=" + this.getBackupUrl() + ")";
    }

    public OceanBaseDataNodeDTO() {
    }

    public OceanBaseDataNodeDTO(String backupUrl) {
        this.backupUrl = backupUrl;
    }

    public static class OceanBaseDataNodeDTOBuilder {
        private String backupUrl;

        OceanBaseDataNodeDTOBuilder() {
        }

        public OceanBaseDataNodeDTOBuilder backupUrl(String backupUrl) {
            this.backupUrl = backupUrl;
            return this;
        }

        public OceanBaseDataNodeDTO build() {
            return new OceanBaseDataNodeDTO(this.backupUrl);
        }

        public String toString() {
            return "OceanBaseDataNodeDTO.OceanBaseDataNodeDTOBuilder(backupUrl=" + this.backupUrl + ")";
        }
    }
}

