/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.impl;

import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.DataNode;
import org.apache.inlong.manager.client.api.inner.client.ClientFactory;
import org.apache.inlong.manager.client.api.inner.client.DataNodeClient;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodePageRequest;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;

public class DataNodeImpl
implements DataNode {
    private final DataNodeClient dataNodeClient;

    public DataNodeImpl(ClientConfiguration configuration) {
        ClientFactory clientFactory = ClientUtils.getClientFactory(configuration);
        this.dataNodeClient = clientFactory.getDataNodeClient();
    }

    @Override
    public Integer save(DataNodeRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"request cannot be null");
        Preconditions.expectNotBlank((String)request.getName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"data node name cannot be blank");
        Preconditions.expectNotBlank((String)request.getType(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"data node type cannot be blank");
        return this.dataNodeClient.save(request);
    }

    @Override
    public DataNodeInfo get(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"data node id cannot be null");
        return this.dataNodeClient.get(id);
    }

    @Override
    public PageResult<DataNodeInfo> list(DataNodePageRequest pageRequest) {
        Preconditions.expectNotNull((Object)pageRequest, (String)"request cannot be null");
        return this.dataNodeClient.list(pageRequest);
    }

    @Override
    public Boolean update(DataNodeRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"request cannot be null");
        Preconditions.expectNotBlank((String)request.getName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"data node name cannot be empty");
        Preconditions.expectNotBlank((String)request.getType(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"data node type cannot be empty");
        Preconditions.expectNotNull((Object)request.getId(), (String)"data node id cannot be null");
        return this.dataNodeClient.update(request);
    }

    @Override
    public Boolean delete(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"data node id cannot be null");
        return this.dataNodeClient.delete(id);
    }
}

