/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.InlongConsumeApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.consume.InlongConsumeBriefInfo;
import org.apache.inlong.manager.pojo.consume.InlongConsumeCountInfo;
import org.apache.inlong.manager.pojo.consume.InlongConsumeInfo;
import org.apache.inlong.manager.pojo.consume.InlongConsumePageRequest;
import org.apache.inlong.manager.pojo.consume.InlongConsumeRequest;
import org.apache.inlong.manager.pojo.workflow.WorkflowResult;

public class InlongConsumeClient {
    private final InlongConsumeApi inlongConsumeApi;

    public InlongConsumeClient(ClientConfiguration configuration) {
        this.inlongConsumeApi = (InlongConsumeApi)ClientUtils.createRetrofit(configuration).create(InlongConsumeApi.class);
    }

    public Integer save(InlongConsumeRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"inlong consume request cannot be null");
        Preconditions.expectNotBlank((String)request.getTopic(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"inlong consume topic cannot be null");
        Preconditions.expectNotBlank((String)request.getConsumerGroup(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"inlong consume topic cannot be null");
        Response<Integer> response = ClientUtils.executeHttpCall(this.inlongConsumeApi.save(request));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }

    public InlongConsumeInfo get(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"inlong consume id cannot be null");
        Response<InlongConsumeInfo> response = ClientUtils.executeHttpCall(this.inlongConsumeApi.get(id));
        ClientUtils.assertRespSuccess(response);
        return (InlongConsumeInfo)response.getData();
    }

    public InlongConsumeCountInfo countStatusByUser() {
        Response<InlongConsumeCountInfo> response = ClientUtils.executeHttpCall(this.inlongConsumeApi.countStatusByUser());
        ClientUtils.assertRespSuccess(response);
        return (InlongConsumeCountInfo)response.getData();
    }

    public PageResult<InlongConsumeBriefInfo> list(InlongConsumePageRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"inlong consume request cannot be null");
        Response<PageResult<InlongConsumeBriefInfo>> response = ClientUtils.executeHttpCall(this.inlongConsumeApi.list(request));
        ClientUtils.assertRespSuccess(response);
        return (PageResult)response.getData();
    }

    public Integer update(InlongConsumeRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"inlong consume request cannot be null");
        Response<Integer> response = ClientUtils.executeHttpCall(this.inlongConsumeApi.update(request));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }

    public Boolean delete(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"inlong consume id cannot be null");
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongConsumeApi.delete(id));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public WorkflowResult startProcess(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"inlong consume id cannot be null");
        Response<WorkflowResult> response = ClientUtils.executeHttpCall(this.inlongConsumeApi.startProcess(id));
        ClientUtils.assertRespSuccess(response);
        return (WorkflowResult)response.getData();
    }
}

