/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.inlong.manager.client.api.InlongStream;
import org.apache.inlong.manager.client.api.inner.InnerStreamContext;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.ApplyGroupProcessForm;

public class InnerGroupContext {
    private InlongGroupInfo groupInfo;
    private Map<String, InnerStreamContext> streamContextMap = Maps.newHashMap();
    private Map<String, InlongStream> streamMap = Maps.newHashMap();
    private ApplyGroupProcessForm initMsg;

    public String getGroupId() {
        Preconditions.expectNotNull((Object)this.groupInfo, (String)"inlong group info was not init");
        return this.groupInfo.getInlongGroupId();
    }

    public void setStreamContext(InnerStreamContext streamContext) {
        Preconditions.expectTrue((streamContext != null && streamContext.getStreamInfo() != null ? 1 : 0) != 0, (String)"stream context cannot be null");
        if (MapUtils.isEmpty(this.streamContextMap)) {
            this.streamContextMap = Maps.newHashMap();
        }
        this.streamContextMap.put(streamContext.getStreamInfo().getName(), streamContext);
    }

    public void setStream(InlongStream stream) {
        Preconditions.expectTrue((stream != null ? 1 : 0) != 0, (String)"stream cannot be null");
        if (MapUtils.isEmpty(this.streamMap)) {
            this.streamMap = Maps.newHashMap();
        }
        this.streamMap.put(stream.getInlongStreamId(), stream);
    }

    public InlongGroupInfo getGroupInfo() {
        return this.groupInfo;
    }

    public Map<String, InnerStreamContext> getStreamContextMap() {
        return this.streamContextMap;
    }

    public Map<String, InlongStream> getStreamMap() {
        return this.streamMap;
    }

    public ApplyGroupProcessForm getInitMsg() {
        return this.initMsg;
    }

    public void setGroupInfo(InlongGroupInfo groupInfo) {
        this.groupInfo = groupInfo;
    }

    public void setStreamContextMap(Map<String, InnerStreamContext> streamContextMap) {
        this.streamContextMap = streamContextMap;
    }

    public void setStreamMap(Map<String, InlongStream> streamMap) {
        this.streamMap = streamMap;
    }

    public void setInitMsg(ApplyGroupProcessForm initMsg) {
        this.initMsg = initMsg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InnerGroupContext)) {
            return false;
        }
        InnerGroupContext other = (InnerGroupContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InlongGroupInfo this$groupInfo = this.getGroupInfo();
        InlongGroupInfo other$groupInfo = other.getGroupInfo();
        if (this$groupInfo == null ? other$groupInfo != null : !this$groupInfo.equals(other$groupInfo)) {
            return false;
        }
        Map<String, InnerStreamContext> this$streamContextMap = this.getStreamContextMap();
        Map<String, InnerStreamContext> other$streamContextMap = other.getStreamContextMap();
        if (this$streamContextMap == null ? other$streamContextMap != null : !((Object)this$streamContextMap).equals(other$streamContextMap)) {
            return false;
        }
        Map<String, InlongStream> this$streamMap = this.getStreamMap();
        Map<String, InlongStream> other$streamMap = other.getStreamMap();
        if (this$streamMap == null ? other$streamMap != null : !((Object)this$streamMap).equals(other$streamMap)) {
            return false;
        }
        ApplyGroupProcessForm this$initMsg = this.getInitMsg();
        ApplyGroupProcessForm other$initMsg = other.getInitMsg();
        return !(this$initMsg == null ? other$initMsg != null : !this$initMsg.equals(other$initMsg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InnerGroupContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InlongGroupInfo $groupInfo = this.getGroupInfo();
        result = result * 59 + ($groupInfo == null ? 43 : $groupInfo.hashCode());
        Map<String, InnerStreamContext> $streamContextMap = this.getStreamContextMap();
        result = result * 59 + ($streamContextMap == null ? 43 : ((Object)$streamContextMap).hashCode());
        Map<String, InlongStream> $streamMap = this.getStreamMap();
        result = result * 59 + ($streamMap == null ? 43 : ((Object)$streamMap).hashCode());
        ApplyGroupProcessForm $initMsg = this.getInitMsg();
        result = result * 59 + ($initMsg == null ? 43 : $initMsg.hashCode());
        return result;
    }

    public String toString() {
        return "InnerGroupContext(groupInfo=" + this.getGroupInfo() + ", streamContextMap=" + this.getStreamContextMap() + ", streamMap=" + this.getStreamMap() + ", initMsg=" + this.getInitMsg() + ")";
    }
}

