/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.util.Arrays;
import org.apache.inlong.manager.client.cli.AbstractCommand;
import org.apache.inlong.manager.client.cli.CreateCommand;
import org.apache.inlong.manager.client.cli.DeleteCommand;
import org.apache.inlong.manager.client.cli.DescribeCommand;
import org.apache.inlong.manager.client.cli.ListCommand;
import org.apache.inlong.manager.client.cli.LogCommand;
import org.apache.inlong.manager.client.cli.RestartCommand;
import org.apache.inlong.manager.client.cli.SuspendCommand;
import org.apache.inlong.manager.client.cli.UpdateCommand;

public class CommandToolMain {
    private final JCommander jcommander = new JCommander();
    @Parameter(names={"-h", "--help"}, help=true, description="Get all command about managerctl.")
    boolean help;

    CommandToolMain() {
        this.jcommander.setProgramName("managerctl");
        this.jcommander.addObject((Object)this);
        this.jcommander.addCommand("list", (Object)new ListCommand());
        this.jcommander.addCommand("describe", (Object)new DescribeCommand());
        this.jcommander.addCommand("create", (Object)new CreateCommand());
        this.jcommander.addCommand("suspend", (Object)new SuspendCommand());
        this.jcommander.addCommand("restart", (Object)new RestartCommand());
        this.jcommander.addCommand("delete", (Object)new DeleteCommand());
        this.jcommander.addCommand("update", (Object)new UpdateCommand());
        this.jcommander.addCommand("log", (Object)new LogCommand());
    }

    public static void main(String[] args) {
        CommandToolMain inlongAdminTool = new CommandToolMain();
        if (inlongAdminTool.run(args)) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    boolean run(String[] args) {
        try {
            this.jcommander.parse(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            this.jcommander.usage();
            return false;
        }
        if (this.help || args.length == 0) {
            this.jcommander.usage();
            return true;
        }
        String cmd = args[0];
        JCommander obj = (JCommander)this.jcommander.getCommands().get(cmd);
        AbstractCommand cmdObj = (AbstractCommand)obj.getObjects().get(0);
        return cmdObj.run(Arrays.copyOfRange(args, 1, args.length));
    }
}

