/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.metric;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.inlong.common.metric.MetricItem;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.common.metric.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricRegister {
    public static final Logger LOGGER = LoggerFactory.getLogger(MetricRegister.class);
    public static final String JMX_DOMAIN = "org.apache.inlong";

    public static void register(MetricItem obj) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        StringBuilder beanName = new StringBuilder();
        beanName.append(JMX_DOMAIN).append(':').append("type=").append(MetricUtils.getDomain(obj.getClass())).append(",").append(obj.getDimensionsKey());
        String strBeanName = beanName.toString();
        try {
            ObjectName objName = new ObjectName(strBeanName);
            mbs.registerMBean(obj, objName);
        }
        catch (Exception ex) {
            LOGGER.error("exception while register mbean:{},error:{}", (Object)strBeanName, (Object)ex.getMessage());
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public static void register(MetricItemSet<? extends MetricItem> obj) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        StringBuilder beanName = new StringBuilder();
        beanName.append(JMX_DOMAIN).append(':').append("type=").append(MetricUtils.getDomain(obj.getClass())).append(",name=").append(obj.getName());
        String strBeanName = beanName.toString();
        try {
            ObjectName objName = new ObjectName(strBeanName);
            mbs.registerMBean(obj, objName);
        }
        catch (Exception ex) {
            LOGGER.error("exception while register mbean:{},error:{}", (Object)strBeanName, (Object)ex.getMessage());
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public static void unregister(MetricItem obj) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        StringBuilder beanName = new StringBuilder();
        beanName.append(JMX_DOMAIN).append(':').append("type=").append(MetricUtils.getDomain(obj.getClass())).append(",").append(obj.getDimensionsKey());
        String strBeanName = beanName.toString();
        try {
            ObjectName objName = new ObjectName(strBeanName);
            mbs.unregisterMBean(objName);
        }
        catch (Exception ex) {
            LOGGER.error("exception while unregister mbean:{},error:{}", (Object)strBeanName, (Object)ex.getMessage());
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public static void unregister(MetricItemSet<? extends MetricItem> obj) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        StringBuilder beanName = new StringBuilder();
        beanName.append(JMX_DOMAIN).append(':').append("type=").append(MetricUtils.getDomain(obj.getClass())).append(",name=").append(obj.getName());
        String strBeanName = beanName.toString();
        try {
            ObjectName objName = new ObjectName(strBeanName);
            mbs.unregisterMBean(objName);
        }
        catch (Exception ex) {
            LOGGER.error("exception while unregister mbean:{},error:{}", (Object)strBeanName, (Object)ex.getMessage());
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

