/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.mq;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.inlong.sdk.commons.protocol.ProxySdk;
import org.apache.inlong.sdk.commons.protocol.SourceCallback;

public class BatchPackProfileCallback {
    private final AtomicInteger ackingCount;
    private final SourceCallback callback;

    public BatchPackProfileCallback(int totalCount, SourceCallback callback) {
        this.ackingCount = new AtomicInteger(totalCount);
        this.callback = callback;
    }

    public void ack(int eventCount) {
        int currentCount = this.ackingCount.addAndGet(-eventCount);
        if (currentCount <= 0) {
            this.callback.callback(ProxySdk.ResultCode.SUCCUSS);
        }
    }

    public void fail() {
        this.callback.callback(ProxySdk.ResultCode.ERR_REJECT);
    }
}

